/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.SQSCallback;
import com.zendesk.maxwell.producer.partitioners.MaxwellSQSPartitioner;
import com.zendesk.maxwell.row.RowMap;

public class MaxwellSQSProducer
extends AbstractAsyncProducer {
    private AmazonSQSAsync client;
    private String queueUri;
    private MaxwellSQSPartitioner partitioner;

    public MaxwellSQSProducer(MaxwellContext context, String queueUri, String serviceEndpoint, String signingRegion) {
        super(context);
        this.queueUri = queueUri;
        this.client = (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(serviceEndpoint, signingRegion))).build();
        String partitionKey = context.getConfig().producerPartitionKey;
        String partitionColumns = context.getConfig().producerPartitionColumns;
        String partitionFallback = context.getConfig().producerPartitionFallback;
        this.partitioner = new MaxwellSQSPartitioner(partitionKey, partitionColumns, partitionFallback);
    }

    @Override
    public void sendAsync(RowMap r, AbstractAsyncProducer.CallbackCompleter cc) throws Exception {
        String value = r.toJSON(this.outputConfig);
        SendMessageRequest messageRequest = new SendMessageRequest(this.queueUri, value);
        if (this.queueUri.endsWith(".fifo")) {
            String key = this.partitioner.getSQSKey(r);
            messageRequest.setMessageGroupId(key);
        }
        SQSCallback callback = new SQSCallback(cc, r.getNextPosition(), value, this.context);
        this.client.sendMessageAsync(messageRequest, (AsyncHandler)callback);
    }
}

