/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.replication;

import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.Table;
import java.util.HashMap;

public class TableCache {
    private final String maxwellDB;
    private final HashMap<Long, Table> tableMapCache = new HashMap();

    public TableCache(String maxwellDB) {
        this.maxwellDB = maxwellDB;
    }

    public void processEvent(Schema schema, Filter filter, Boolean ignoreMissingSchema, Long tableId, String dbName, String tblName) {
        if (!this.tableMapCache.containsKey(tableId)) {
            if (filter.isTableBlacklisted(dbName, tblName)) {
                return;
            }
            Database db = schema.findDatabase(dbName);
            if (db == null) {
                if (!ignoreMissingSchema.booleanValue() || filter.includes(dbName, tblName)) {
                    throw new RuntimeException("Couldn't find database " + dbName);
                }
            } else {
                Table tbl = db.findTable(tblName);
                if (tbl == null) {
                    if (!ignoreMissingSchema.booleanValue() || filter.includes(dbName, tblName)) {
                        throw new RuntimeException("Couldn't find table " + tblName + " in database " + dbName);
                    }
                } else {
                    this.tableMapCache.put(tableId, tbl);
                }
            }
        }
    }

    public Table getTable(Long tableId) {
        return this.tableMapCache.get(tableId);
    }

    public void clear() {
        this.tableMapCache.clear();
    }
}

