/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.github.shyiko.mysql.binlog.event.LRUCache;
import java.util.Map;

public class FieldNameStrategy {
    public static final int TYPE_NONE = 0;
    public static final String NAME_UNDERSCORE_TO_CAMEL_CASE = "underscore_to_camelcase";
    public static final int TYPE_UNDERSCORE_TO_CAMEL_CASE = 1;
    private Map<String, String> caches = new LRUCache(20, 0.75f, 1000);
    private int strategyType = 0;

    public FieldNameStrategy(String strategyName) {
        if (NAME_UNDERSCORE_TO_CAMEL_CASE.equals(strategyName)) {
            this.strategyType = 1;
        }
    }

    public String apply(String oldName) {
        if (this.strategyType == 1) {
            return this.caches.computeIfAbsent(oldName, k -> this.underscore2Camel((String)k));
        }
        return oldName;
    }

    private String underscore2Camel(String oldName) {
        StringBuilder newName = new StringBuilder(oldName.length());
        int len = oldName.length();
        for (int i = 0; i < len; ++i) {
            char c = oldName.charAt(i);
            if (c == '_') {
                char ch;
                if (newName.length() <= 0 || i + 1 >= len) continue;
                if (Character.isLowerCase(ch = oldName.charAt(++i))) {
                    ch = Character.toUpperCase(ch);
                }
                newName.append(ch);
                continue;
            }
            newName.append(c);
        }
        if (newName.length() == 0) {
            return oldName;
        }
        return newName.toString();
    }
}

