/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.util.ListWithDiskBuffer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMapBuffer
extends ListWithDiskBuffer<RowMap> {
    static final Logger LOGGER = LoggerFactory.getLogger(RowMapBuffer.class);
    private static long FlushOutputStreamBytes = 10000000L;
    private Long xid;
    private Long xoffset = 0L;
    private Long serverId;
    private Long threadId;
    private Long schemaId;
    private long memorySize = 0L;
    private long outputStreamCacheSize = 0L;
    private final long maxMemory;

    public RowMapBuffer(long maxInMemoryElements) {
        super(maxInMemoryElements);
        this.maxMemory = (long)((double)Runtime.getRuntime().maxMemory() * 0.25);
    }

    public RowMapBuffer(long maxInMemoryElements, long maxMemory) {
        super(maxInMemoryElements);
        this.maxMemory = maxMemory;
    }

    public RowMapBuffer(long maxInMemoryElements, float bufferMemoryUsage) {
        super(maxInMemoryElements);
        this.maxMemory = (long)((float)Runtime.getRuntime().maxMemory() * bufferMemoryUsage);
    }

    @Override
    public void add(RowMap rowMap) throws IOException {
        this.memorySize += rowMap.getApproximateSize();
        super.add(rowMap);
    }

    @Override
    protected boolean shouldBuffer() {
        return this.memorySize > this.maxMemory;
    }

    @Override
    protected RowMap evict() throws IOException {
        RowMap r = (RowMap)super.evict();
        this.memorySize -= r.getApproximateSize();
        this.outputStreamCacheSize += r.getApproximateSize();
        if (this.outputStreamCacheSize > FlushOutputStreamBytes) {
            this.resetOutputStreamCaches();
            LOGGER.debug("outputStreamCacheSize: {}, memorySize: {}", (Object)this.outputStreamCacheSize, (Object)this.memorySize);
            this.outputStreamCacheSize = 0L;
        }
        return r;
    }

    public RowMap removeFirst() throws IOException, ClassNotFoundException {
        RowMap r = super.removeFirst(RowMap.class);
        r.setXid(this.xid);
        Long l = this.xoffset;
        Long l2 = this.xoffset = Long.valueOf(this.xoffset + 1L);
        r.setXoffset(l);
        r.setServerId(this.serverId);
        r.setThreadId(this.threadId);
        r.setSchemaId(this.schemaId);
        return r;
    }

    public void setXid(Long xid) {
        this.xid = xid;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public void setSchemaId(Long schemaId) {
        this.schemaId = schemaId;
    }
}

