/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.SchemaCapturer;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.columndef.BigIntColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefWithLength;
import com.zendesk.maxwell.schema.columndef.EnumeratedColumnDef;
import com.zendesk.maxwell.schema.columndef.IntColumnDef;
import com.zendesk.maxwell.schema.columndef.StringColumnDef;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;
import com.zendesk.maxwell.util.ConnectionPool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSavedSchema {
    static int SchemaStoreVersion = 4;
    private Schema schema;
    private Position position;
    private Long schemaID;
    private int schemaVersion;
    private Long baseSchemaID;
    private List<ResolvedSchemaChange> deltas;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JavaType listOfResolvedSchemaChangeType = mapper.getTypeFactory().constructCollectionType(List.class, ResolvedSchemaChange.class);
    static final Logger LOGGER = LoggerFactory.getLogger(MysqlSavedSchema.class);
    private static final String columnInsertSQL = "INSERT INTO `columns` (schema_id, table_id, name, charset, coltype, is_signed, enum_values, column_length) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private final CaseSensitivity sensitivity;
    private final Long serverID;
    private boolean shouldSnapshotNextSchema = false;

    public MysqlSavedSchema(Long serverID, CaseSensitivity sensitivity) throws SQLException {
        this.serverID = serverID;
        this.sensitivity = sensitivity;
    }

    public MysqlSavedSchema(Long serverID, CaseSensitivity sensitivity, Schema schema, Position position) throws SQLException {
        this(serverID, sensitivity);
        this.schema = schema;
        this.setPosition(position);
    }

    public MysqlSavedSchema(MaxwellContext context, Schema schema, Position position) throws SQLException {
        this(context.getServerID(), context.getCaseSensitivity(), schema, position);
    }

    public MysqlSavedSchema(Long serverID, CaseSensitivity sensitivity, Schema schema, Position position, long baseSchemaID, List<ResolvedSchemaChange> deltas) throws SQLException {
        this(serverID, sensitivity, schema, position);
        this.baseSchemaID = baseSchemaID;
        this.deltas = deltas;
    }

    public MysqlSavedSchema createDerivedSchema(Schema newSchema, Position position, List<ResolvedSchemaChange> deltas) throws SQLException {
        if (this.shouldSnapshotNextSchema) {
            return new MysqlSavedSchema(this.serverID, this.sensitivity, newSchema, position);
        }
        return new MysqlSavedSchema(this.serverID, this.sensitivity, newSchema, position, this.schemaID, deltas);
    }

    public Long getSchemaID() {
        return this.schemaID;
    }

    private static Long executeInsert(PreparedStatement preparedStatement, Object ... values) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            preparedStatement.setObject(i + 1, values[i]);
        }
        preparedStatement.executeUpdate();
        try (ResultSet rs = preparedStatement.getGeneratedKeys();){
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public Long save(Connection connection) throws SQLException {
        if (this.schema == null) {
            throw new RuntimeException("Uninitialized schema!");
        }
        this.schemaID = this.findSchemaForPositionSHA(connection, this.getPositionSHA());
        if (this.schemaID != null) {
            return this.schemaID;
        }
        try {
            connection.setAutoCommit(false);
            this.schemaID = this.saveSchema(connection);
            connection.commit();
        }
        catch (SQLIntegrityConstraintViolationException e) {
            connection.rollback();
            connection.setAutoCommit(true);
            this.schemaID = this.findSchemaForPositionSHA(connection, this.getPositionSHA());
        }
        finally {
            connection.setAutoCommit(true);
        }
        return this.schemaID;
    }

    private Long findSchemaForPositionSHA(Connection c, String sha) throws SQLException {
        try (PreparedStatement p = c.prepareStatement("SELECT * from `schemas` where position_sha = ?");){
            Long l;
            block16: {
                ResultSet rs;
                block14: {
                    Long l2;
                    block15: {
                        p.setString(1, sha);
                        rs = p.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            Long id = rs.getLong("id");
                            LOGGER.debug("findSchemaForPositionSHA: found schema_id: {} for sha: {}", (Object)id, (Object)sha);
                            l2 = id;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = null;
                if (rs == null) break block16;
                rs.close();
            }
            return l;
        }
    }

    private Long saveDerivedSchema(Connection conn) throws SQLException {
        try (PreparedStatement insert = conn.prepareStatement("INSERT into `schemas` SET base_schema_id = ?, deltas = ?, binlog_file = ?, binlog_position = ?, server_id = ?, charset = ?, version = ?, position_sha = ?, gtid_set = ?, last_heartbeat_read = ?", 1);){
            String deltaString;
            try {
                deltaString = mapper.writerFor(listOfResolvedSchemaChangeType).writeValueAsString(this.deltas);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Couldn't serialize " + this.deltas + " to JSON.", e);
            }
            BinlogPosition binlogPosition = this.position.getBinlogPosition();
            Long l = MysqlSavedSchema.executeInsert(insert, this.baseSchemaID, deltaString, binlogPosition.getFile(), binlogPosition.getOffset(), this.serverID, this.schema.getCharset(), SchemaStoreVersion, this.getPositionSHA(), binlogPosition.getGtidSetStr(), this.position.getLastHeartbeatRead());
            return l;
        }
    }

    public Long saveSchema(Connection conn) throws SQLException {
        Long schemaId;
        if (this.baseSchemaID != null) {
            return this.saveDerivedSchema(conn);
        }
        try (PreparedStatement schemaInsert = conn.prepareStatement("INSERT INTO `schemas` SET binlog_file = ?, binlog_position = ?, server_id = ?, charset = ?, version = ?, position_sha = ?, gtid_set = ?, last_heartbeat_read = ?", 1);){
            BinlogPosition binlogPosition = this.position.getBinlogPosition();
            schemaId = MysqlSavedSchema.executeInsert(schemaInsert, binlogPosition.getFile(), binlogPosition.getOffset(), this.serverID, this.schema.getCharset(), SchemaStoreVersion, this.getPositionSHA(), binlogPosition.getGtidSetStr(), this.position.getLastHeartbeatRead());
        }
        this.saveFullSchema(conn, schemaId);
        return schemaId;
    }

    public void saveFullSchema(Connection conn, Long schemaId) throws SQLException {
        try (PreparedStatement databaseInsert = conn.prepareStatement("INSERT INTO `databases` SET schema_id = ?, name = ?, charset=?", 1);
             PreparedStatement tableInsert = conn.prepareStatement("INSERT INTO `tables` SET schema_id = ?, database_id = ?, name = ?, charset=?, pk=?", 1);){
            ArrayList<Object> columnData = new ArrayList<Object>();
            for (Database d : this.schema.getDatabases()) {
                Long dbId = MysqlSavedSchema.executeInsert(databaseInsert, schemaId, d.getName(), d.getCharset());
                for (Table t : d.getTableList()) {
                    Long tableId = MysqlSavedSchema.executeInsert(tableInsert, schemaId, dbId, t.getName(), t.getCharset(), t.getPKString());
                    for (ColumnDef c : t.getColumnList()) {
                        EnumeratedColumnDef enumColumn;
                        String enumValuesSQL = null;
                        if (c instanceof EnumeratedColumnDef && (enumColumn = (EnumeratedColumnDef)c).getEnumValues() != null) {
                            try {
                                enumValuesSQL = mapper.writeValueAsString(enumColumn.getEnumValues());
                            }
                            catch (JsonProcessingException e) {
                                throw new SQLException(e);
                            }
                        }
                        columnData.add(schemaId);
                        columnData.add(tableId);
                        columnData.add(c.getName());
                        if (c instanceof StringColumnDef) {
                            columnData.add(((StringColumnDef)c).getCharset());
                        } else {
                            columnData.add(null);
                        }
                        columnData.add(c.getType());
                        if (c instanceof IntColumnDef) {
                            columnData.add(((IntColumnDef)c).isSigned() ? 1 : 0);
                        } else if (c instanceof BigIntColumnDef) {
                            columnData.add(((BigIntColumnDef)c).isSigned() ? 1 : 0);
                        } else {
                            columnData.add(0);
                        }
                        columnData.add(enumValuesSQL);
                        if (c instanceof ColumnDefWithLength) {
                            Long columnLength = ((ColumnDefWithLength)c).getColumnLength();
                            columnData.add(columnLength);
                            continue;
                        }
                        columnData.add(null);
                    }
                    if (columnData.size() <= 1000) continue;
                    this.executeColumnInsert(conn, columnData);
                }
            }
            if (columnData.size() > 0) {
                this.executeColumnInsert(conn, columnData);
            }
        }
    }

    private void executeColumnInsert(Connection conn, ArrayList<Object> columnData) throws SQLException {
        Object insertColumnSQL = columnInsertSQL;
        for (int i = 1; i < columnData.size() / 8; ++i) {
            insertColumnSQL = (String)insertColumnSQL + ", (?, ?, ?, ?, ?, ?, ?, ?)";
        }
        try (PreparedStatement columnInsert = conn.prepareStatement((String)insertColumnSQL);){
            int i = 1;
            for (Object o : columnData) {
                columnInsert.setObject(i++, o);
            }
            columnInsert.execute();
        }
        columnData.clear();
    }

    public static MysqlSavedSchema restore(MaxwellContext context, Position targetPosition) throws SQLException, InvalidSchemaError {
        return MysqlSavedSchema.restore(context.getMaxwellConnectionPool(), context.getServerID(), context.getCaseSensitivity(), targetPosition);
    }

    public static MysqlSavedSchema restore(ConnectionPool pool, Long serverID, CaseSensitivity caseSensitivity, Position targetPosition) throws SQLException, InvalidSchemaError {
        try (Connection conn = pool.getConnection();){
            Long schemaID = MysqlSavedSchema.findSchema(conn, targetPosition, serverID);
            if (schemaID == null) {
                MysqlSavedSchema mysqlSavedSchema = null;
                return mysqlSavedSchema;
            }
            MysqlSavedSchema savedSchema = new MysqlSavedSchema(serverID, caseSensitivity);
            savedSchema.restoreFromSchemaID(conn, schemaID);
            savedSchema.handleVersionUpgrades(pool);
            MysqlSavedSchema mysqlSavedSchema = savedSchema;
            return mysqlSavedSchema;
        }
    }

    public static MysqlSavedSchema restoreFromSchemaID(Long schemaID, Connection conn, CaseSensitivity sensitivity) throws SQLException, InvalidSchemaError {
        MysqlSavedSchema savedSchema = new MysqlSavedSchema(schemaID, sensitivity);
        savedSchema.restoreFromSchemaID(conn, schemaID);
        return savedSchema;
    }

    private List<ResolvedSchemaChange> parseDeltas(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (List)mapper.readerFor(listOfResolvedSchemaChangeType).readValue(json.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't parse json delta: " + json.getBytes(), e);
        }
    }

    private HashMap<Long, HashMap<String, Object>> buildSchemaMap(Connection conn) throws SQLException {
        HashMap<Long, HashMap<String, Object>> schemas = new HashMap<Long, HashMap<String, Object>>();
        try (PreparedStatement p = conn.prepareStatement("SELECT * from `schemas`");){
            HashMap<Long, HashMap<String, Object>> hashMap;
            block14: {
                ResultSet rs = p.executeQuery();
                try {
                    ResultSetMetaData md = rs.getMetaData();
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        for (int i = 1; i <= md.getColumnCount(); ++i) {
                            row.put(md.getColumnName(i), rs.getObject(i));
                        }
                        schemas.put(rs.getLong("id"), row);
                    }
                    hashMap = schemas;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
    }

    private LinkedList<Long> buildSchemaChain(HashMap<Long, HashMap<String, Object>> schemas, Long schema_id) {
        LinkedList<Long> schemaChain = new LinkedList<Long>();
        while (schema_id != null) {
            if (!schemas.containsKey(schema_id)) {
                throw new RuntimeException("Couldn't find chained schema: " + schema_id);
            }
            schemaChain.addFirst(schema_id);
            schema_id = (Long)schemas.get(schema_id).get("base_schema_id");
        }
        return schemaChain;
    }

    private void restoreDerivedSchema(Connection conn, Long schema_id) throws SQLException, InvalidSchemaError {
        HashMap<Long, HashMap<String, Object>> schemas = this.buildSchemaMap(conn);
        LinkedList<Long> schemaChain = this.buildSchemaChain(schemas, schema_id);
        Long firstSchemaId = schemaChain.removeFirst();
        MysqlSavedSchema firstSchema = new MysqlSavedSchema(this.serverID, this.sensitivity);
        firstSchema.restoreFromSchemaID(conn, firstSchemaId);
        Schema schema = firstSchema.getSchema();
        LOGGER.info("beginning to play deltas...");
        int count = 0;
        long startTime = System.currentTimeMillis();
        for (Long id : schemaChain) {
            List<ResolvedSchemaChange> deltas = this.parseDeltas((String)schemas.get(id).get("deltas"));
            for (ResolvedSchemaChange delta : deltas) {
                delta.apply(schema);
            }
            ++count;
        }
        this.schema = schema;
        long elapsed = System.currentTimeMillis() - startTime;
        LOGGER.info("played " + count + " deltas in " + elapsed + "ms");
    }

    protected void restoreFromSchemaID(Connection conn, Long schemaID) throws SQLException, InvalidSchemaError {
        this.restoreSchemaMetadata(conn, schemaID);
        if (this.baseSchemaID != null) {
            LOGGER.debug("Restoring derived schema");
            this.restoreDerivedSchema(conn, schemaID);
        } else {
            LOGGER.debug("Restoring full schema");
            this.restoreFullSchema(conn, schemaID);
        }
    }

    private void restoreSchemaMetadata(Connection conn, Long schemaID) throws SQLException {
        try (PreparedStatement p = conn.prepareStatement("select * from `schemas` where id = " + schemaID);
             ResultSet schemaRS = p.executeQuery();){
            schemaRS.next();
            this.setPosition(new Position(new BinlogPosition(schemaRS.getString("gtid_set"), null, schemaRS.getInt("binlog_position"), schemaRS.getString("binlog_file")), schemaRS.getLong("last_heartbeat_read")));
            LOGGER.info("Restoring schema id " + schemaRS.getLong("id") + " (last modified at " + this.position + ")");
            this.schemaID = schemaRS.getLong("id");
            this.baseSchemaID = schemaRS.getLong("base_schema_id");
            if (schemaRS.wasNull()) {
                this.baseSchemaID = null;
            }
            this.deltas = this.parseDeltas(schemaRS.getString("deltas"));
            this.schemaVersion = schemaRS.getInt("version");
            this.schema = new Schema(new ArrayList<Database>(), schemaRS.getString("charset"), this.sensitivity);
        }
    }

    private void restoreFullSchema(Connection conn, Long schemaID) throws SQLException, InvalidSchemaError {
        String sql = "SELECT d.id AS dbId,d.name AS dbName,d.charset AS dbCharset,t.name AS tableName,t.charset AS tableCharset,t.pk AS tablePk,t.id AS tableId,c.column_length AS columnLength,c.enum_values AS columnEnumValues,c.name AS columnName,c.charset AS columnCharset,c.coltype AS columnColtype,c.is_signed AS columnIsSigned FROM `databases` d LEFT JOIN tables t ON d.id = t.database_id LEFT JOIN columns c ON c.table_id=t.id WHERE d.schema_id = ? ORDER BY d.id, t.id, c.id";
        try (PreparedStatement p = conn.prepareStatement(sql);){
            p.setLong(1, this.schemaID);
            try (ResultSet rs = p.executeQuery();){
                Database currentDatabase = null;
                Table currentTable = null;
                short columnIndex = 0;
                ArrayList<ColumnDef> columns = new ArrayList<ColumnDef>();
                while (rs.next()) {
                    String dbName = rs.getString("dbName");
                    String dbCharset = rs.getString("dbCharset");
                    String tName = rs.getString("tableName");
                    String tCharset = rs.getString("tableCharset");
                    String tPKs = rs.getString("tablePk");
                    String columnName = rs.getString("columnName");
                    int columnLengthInt = rs.getInt("columnLength");
                    String columnEnumValues = rs.getString("columnEnumValues");
                    String columnCharset = rs.getString("columnCharset");
                    String columnType = rs.getString("columnColtype");
                    int columnIsSigned = rs.getInt("columnIsSigned");
                    if (currentDatabase == null || !currentDatabase.getName().equals(dbName)) {
                        if (currentTable != null) {
                            currentTable.addColumns(columns);
                            columns.clear();
                        }
                        currentDatabase = new Database(dbName, dbCharset);
                        this.schema.addDatabase(currentDatabase);
                        currentTable = null;
                        LOGGER.debug("Restoring database {}...", (Object)dbName);
                    }
                    if (tName == null) continue;
                    if (currentTable == null || !currentTable.getName().equals(tName)) {
                        if (currentTable != null) {
                            currentTable.addColumns(columns);
                            columns.clear();
                        }
                        currentTable = currentDatabase.buildTable(tName, tCharset);
                        if (tPKs != null) {
                            List<String> pkList = Arrays.asList(StringUtils.split((String)tPKs, (char)','));
                            currentTable.setPKList(pkList);
                        }
                        columnIndex = 0;
                    }
                    if (columnName == null) continue;
                    Long columnLength = rs.wasNull() ? null : Long.valueOf(columnLengthInt);
                    String[] enumValues = null;
                    if (columnEnumValues != null) {
                        if (this.schemaVersion >= 4) {
                            try {
                                enumValues = (String[])mapper.readValue(columnEnumValues, String[].class);
                            }
                            catch (IOException e) {
                                throw new SQLException(e);
                            }
                        } else {
                            enumValues = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)columnEnumValues, (String)",");
                        }
                    }
                    short s = columnIndex;
                    columnIndex = (short)(columnIndex + 1);
                    ColumnDef c = ColumnDef.build(columnName, columnCharset, columnType, s, columnIsSigned == 1, enumValues, columnLength);
                    columns.add(c);
                }
                if (currentTable != null) {
                    currentTable.addColumns(columns);
                }
                LOGGER.debug("Restored all databases");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Long findSchema(Connection connection, Position targetPosition, Long serverID) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    private void setPosition(Position position) {
        this.position = position;
    }

    public static void delete(Connection connection, long schema_id) throws SQLException {
        connection.createStatement().execute("update `schemas` set deleted = 1 where id = " + schema_id);
    }

    public BinlogPosition getBinlogPosition() {
        if (this.position == null) {
            return null;
        }
        return this.position.getBinlogPosition();
    }

    public Position getPosition() {
        return this.position;
    }

    private void fixUnsignedColumns(Schema recaptured) throws SQLException, InvalidSchemaError {
        int unsignedDiffs = 0;
        for (Pair<Schema.FullColumnDef, Schema.FullColumnDef> pair : this.schema.matchColumns(recaptured)) {
            Table schemaTable = ((Schema.FullColumnDef)pair.getLeft()).getTable();
            ColumnDef schemaCol = ((Schema.FullColumnDef)pair.getLeft()).getColumnDef();
            ColumnDef recapturedCol = ((Schema.FullColumnDef)pair.getRight()).getColumnDef();
            if (schemaCol instanceof IntColumnDef) {
                if (recapturedCol != null && recapturedCol instanceof IntColumnDef) {
                    if (!((IntColumnDef)schemaCol).isSigned() || ((IntColumnDef)recapturedCol).isSigned()) continue;
                    schemaTable.replaceColumn(schemaCol.getPos(), ((IntColumnDef)schemaCol).withSigned(false));
                    ++unsignedDiffs;
                    continue;
                }
                LOGGER.warn("warning: Couldn't check for unsigned integer bug on column " + schemaCol.getName() + ".  You may want to recapture your schema");
                continue;
            }
            if (!(schemaCol instanceof BigIntColumnDef)) continue;
            if (recapturedCol != null && recapturedCol instanceof BigIntColumnDef) {
                if (((BigIntColumnDef)schemaCol).isSigned() && !((BigIntColumnDef)recapturedCol).isSigned()) {
                    schemaTable.replaceColumn(schemaCol.getPos(), ((BigIntColumnDef)schemaCol).withSigned(false));
                }
                ++unsignedDiffs;
                continue;
            }
            LOGGER.warn("warning: Couldn't check for unsigned integer bug on column " + schemaCol.getName() + ".  You may want to recapture your schema");
        }
        if (unsignedDiffs > 0) {
            this.shouldSnapshotNextSchema = true;
        }
    }

    private void fixColumnCases(Schema recaptured) throws InvalidSchemaError {
        int caseDiffs = 0;
        for (Pair<Schema.FullColumnDef, Schema.FullColumnDef> pair : this.schema.matchColumns(recaptured)) {
            Table schemaTable = ((Schema.FullColumnDef)pair.getLeft()).getTable();
            ColumnDef schemaCol = ((Schema.FullColumnDef)pair.getLeft()).getColumnDef();
            ColumnDef recapturedCol = ((Schema.FullColumnDef)pair.getRight()).getColumnDef();
            if (schemaCol.getName().equals(recapturedCol.getName())) continue;
            LOGGER.info("correcting column case of `" + schemaCol.getName() + "` to `" + recapturedCol.getName() + "`.  Will save a full schema snapshot after the new DDL update is processed.");
            ++caseDiffs;
            schemaTable.replaceColumn(schemaCol.getPos(), schemaCol.withName(recapturedCol.getName()));
        }
    }

    private void fixColumnLength(Schema recaptured) throws InvalidSchemaError {
        int colLengthDiffs = 0;
        for (Pair<Schema.FullColumnDef, Schema.FullColumnDef> pair : this.schema.matchColumns(recaptured)) {
            Table schemaTable = ((Schema.FullColumnDef)pair.getLeft()).getTable();
            ColumnDef schemaCol = ((Schema.FullColumnDef)pair.getLeft()).getColumnDef();
            ColumnDef recapturedCol = ((Schema.FullColumnDef)pair.getRight()).getColumnDef();
            if (schemaCol instanceof ColumnDefWithLength) {
                if (recapturedCol != null && recapturedCol instanceof ColumnDefWithLength) {
                    long bColLength;
                    long aColLength = ((ColumnDefWithLength)schemaCol).getColumnLength();
                    if (aColLength != (bColLength = ((ColumnDefWithLength)recapturedCol).getColumnLength().longValue())) {
                        ++colLengthDiffs;
                        LOGGER.info("correcting column length of `" + schemaCol.getName() + "` to " + bColLength + ".  Will save a full schema snapshot after the new DDL update is processed.");
                        schemaTable.replaceColumn(schemaCol.getPos(), ((ColumnDefWithLength)schemaCol).withColumnLength(bColLength));
                    }
                } else {
                    LOGGER.warn("warning: Couldn't check for column length on column " + schemaCol.getName() + ".  You may want to recapture your schema");
                }
            }
            if (colLengthDiffs <= 0) continue;
            this.shouldSnapshotNextSchema = true;
        }
    }

    protected void handleVersionUpgrades(ConnectionPool pool) throws SQLException, InvalidSchemaError {
        if (this.schemaVersion < 3) {
            Schema recaptured;
            SchemaCapturer sc;
            try (Connection conn = pool.getConnection();){
                sc = new SchemaCapturer(conn, this.sensitivity);
                try {
                    recaptured = sc.capture();
                }
                finally {
                    sc.close();
                }
            }
            if (this.schemaVersion < 1) {
                if (this.schema != null && this.schema.findDatabase("mysql") == null) {
                    LOGGER.info("Could not find mysql db, adding it to schema");
                    conn = pool.getConnection();
                    try {
                        sc = new SchemaCapturer(conn, this.sensitivity, "mysql");
                        try {
                            Database db = sc.capture().findDatabase("mysql");
                            this.schema.addDatabase(db);
                            this.shouldSnapshotNextSchema = true;
                        }
                        finally {
                            sc.close();
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
                this.fixUnsignedColumns(recaptured);
            }
            if (this.schemaVersion < 2) {
                this.fixColumnCases(recaptured);
            }
            if (this.schemaVersion < 3) {
                this.fixColumnLength(recaptured);
            }
        }
    }

    private String getPositionSHA() {
        return MysqlSavedSchema.getSchemaPositionSHA(this.serverID, this.position);
    }

    public static String getSchemaPositionSHA(Long serverID, Position position) {
        BinlogPosition binlogPosition = position.getBinlogPosition();
        String shaString = String.format("%d/%s/%d/%d", serverID, binlogPosition.getFile(), binlogPosition.getOffset(), position.getLastHeartbeatRead());
        return DigestUtils.shaHex((String)shaString);
    }

    public Long getBaseSchemaID() {
        return this.baseSchemaID;
    }
}

