/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.schema.AbstractSchemaStore;
import com.zendesk.maxwell.schema.MysqlSavedSchema;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.SchemaStore;
import com.zendesk.maxwell.schema.SchemaStoreException;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;
import com.zendesk.maxwell.util.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class MysqlSchemaStore
extends AbstractSchemaStore
implements SchemaStore {
    private final ConnectionPool maxwellConnectionPool;
    private final Position initialPosition;
    private final boolean readOnly;
    private Long serverID;
    private MysqlSavedSchema savedSchema;

    public MysqlSchemaStore(ConnectionPool maxwellConnectionPool, ConnectionPool replicationConnectionPool, ConnectionPool schemaConnectionPool, Long serverID, Position initialPosition, CaseSensitivity caseSensitivity, Filter filter, boolean readOnly) {
        super(replicationConnectionPool, schemaConnectionPool, caseSensitivity, filter);
        this.serverID = serverID;
        this.maxwellConnectionPool = maxwellConnectionPool;
        this.initialPosition = initialPosition;
        this.readOnly = readOnly;
    }

    public MysqlSchemaStore(MaxwellContext context, Position initialPosition) throws SQLException {
        this(context.getMaxwellConnectionPool(), context.getReplicationConnectionPool(), context.getSchemaConnectionPool(), context.getServerID(), initialPosition, context.getCaseSensitivity(), context.getFilter(), context.getReplayMode());
    }

    @Override
    public Schema getSchema() throws SchemaStoreException {
        if (this.savedSchema == null) {
            this.savedSchema = this.restoreOrCaptureSchema();
        }
        return this.savedSchema.getSchema();
    }

    @Override
    public Long getSchemaID() throws SchemaStoreException {
        this.getSchema();
        return this.savedSchema.getSchemaID();
    }

    private MysqlSavedSchema restoreOrCaptureSchema() throws SchemaStoreException {
        try {
            MysqlSavedSchema savedSchema = MysqlSavedSchema.restore(this.maxwellConnectionPool, this.serverID, this.caseSensitivity, this.initialPosition);
            if (savedSchema == null) {
                savedSchema = this.captureAndSaveSchema();
            }
            return savedSchema;
        }
        catch (SQLException e) {
            throw new SchemaStoreException(e);
        }
        catch (InvalidSchemaError e) {
            throw new SchemaStoreException(e);
        }
    }

    public MysqlSavedSchema captureAndSaveSchema() throws SQLException {
        try (Connection conn = this.maxwellConnectionPool.getConnection();){
            MysqlSavedSchema savedSchema = new MysqlSavedSchema(this.serverID, this.caseSensitivity, this.captureSchema(), this.initialPosition);
            if (!this.readOnly) {
                if (conn.isValid(30)) {
                    savedSchema.save(conn);
                } else {
                    try (Connection newConn = this.maxwellConnectionPool.getConnection();){
                        savedSchema.save(newConn);
                    }
                }
            }
            MysqlSavedSchema mysqlSavedSchema = savedSchema;
            return mysqlSavedSchema;
        }
    }

    @Override
    public List<ResolvedSchemaChange> processSQL(String sql, String currentDatabase, Position position) throws SchemaStoreException, InvalidSchemaError {
        List<ResolvedSchemaChange> resolvedSchemaChanges;
        try {
            resolvedSchemaChanges = this.resolveSQL(this.getSchema(), sql, currentDatabase);
        }
        catch (Exception e) {
            LOGGER.error("Error on bin log position " + position.toString());
            e.printStackTrace();
            throw e;
        }
        if (resolvedSchemaChanges.size() > 0) {
            try {
                Long schemaId = this.saveSchema(this.getSchema(), resolvedSchemaChanges, position);
                LOGGER.info("storing schema @" + position + " after applying \"" + sql.replace('\n', ' ') + "\" to " + currentDatabase + ", new schema id is " + schemaId);
            }
            catch (SQLException e) {
                throw new SchemaStoreException(e);
            }
        }
        return resolvedSchemaChanges;
    }

    private Long saveSchema(Schema updatedSchema, List<ResolvedSchemaChange> changes, Position p) throws SQLException {
        if (this.readOnly) {
            return null;
        }
        try (Connection c = this.maxwellConnectionPool.getConnection();){
            this.savedSchema = this.savedSchema.createDerivedSchema(updatedSchema, p, changes);
            Long l = this.savedSchema.save(c);
            return l;
        }
    }

    public void clone(Long serverID, Position position) throws SchemaStoreException {
        List<ResolvedSchemaChange> empty = Collections.emptyList();
        try (Connection c = this.maxwellConnectionPool.getConnection();){
            this.getSchema();
            MysqlSavedSchema cloned = new MysqlSavedSchema(serverID, this.caseSensitivity, this.getSchema(), position, this.savedSchema.getSchemaID(), empty);
            Long schemaId = cloned.save(c);
            LOGGER.info("clone schema @" + position + " based on id " + this.savedSchema.getSchemaID() + ", new schema id is " + schemaId);
        }
        catch (SQLException e) {
            throw new SchemaStoreException(e);
        }
    }
}

