/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatter {
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final ThreadLocal<Calendar> calendarThreadLocal = ThreadLocal.withInitial(() -> Calendar.getInstance());
    private static final ThreadLocal<Calendar> calendarUTCThreadLocal = ThreadLocal.withInitial(() -> Calendar.getInstance(UTC_ZONE));
    private static final ThreadLocal<StringBuilder> stringBuilderThreadLocal = ThreadLocal.withInitial(() -> new StringBuilder(32));

    public static Timestamp extractTimestamp(Object value) throws IllegalArgumentException {
        if (value instanceof Long) {
            Long micros = (Long)value;
            long millis = DateFormatter.floorDiv(micros, 1000L);
            Timestamp t = new Timestamp(millis);
            long microsOnly = DateFormatter.floorMod(micros, 1000000L);
            t.setNanos((int)microsOnly * 1000);
            return t;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            Long time = ((Date)value).getTime();
            return new Timestamp(time);
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)value);
        }
        throw new IllegalArgumentException("couldn't extract date/time out of " + value);
    }

    private static void zeroPad(StringBuilder sb, int val, int width) {
        int digits = val < 10 ? 1 : (val < 100 ? 2 : (val < 1000 ? 3 : (val < 10000 ? 4 : 99999999)));
        int padding = width - digits;
        for (int i = 0; i < padding; ++i) {
            sb.append(0);
        }
        sb.append(val);
    }

    private static String formatDate(Calendar cal) {
        StringBuilder sb = stringBuilderThreadLocal.get();
        sb.setLength(0);
        DateFormatter.zeroPad(sb, cal.get(1), 4);
        sb.append("-");
        DateFormatter.zeroPad(sb, cal.get(2) + 1, 2);
        sb.append("-");
        DateFormatter.zeroPad(sb, cal.get(5), 2);
        return sb.toString();
    }

    private static String formatDateTime(Calendar cal) {
        StringBuilder sb = stringBuilderThreadLocal.get();
        sb.setLength(0);
        DateFormatter.zeroPad(sb, cal.get(1), 4);
        sb.append("-");
        DateFormatter.zeroPad(sb, cal.get(2) + 1, 2);
        sb.append("-");
        DateFormatter.zeroPad(sb, cal.get(5), 2);
        sb.append(" ");
        DateFormatter.zeroPad(sb, cal.get(11), 2);
        sb.append(":");
        DateFormatter.zeroPad(sb, cal.get(12), 2);
        sb.append(":");
        DateFormatter.zeroPad(sb, cal.get(13), 2);
        return sb.toString();
    }

    public static String formatDate(Object value) {
        Calendar cal;
        if (value instanceof Long) {
            cal = calendarUTCThreadLocal.get();
            cal.setTimeInMillis(DateFormatter.floorDiv((Long)value, 1000L));
        } else {
            cal = calendarThreadLocal.get();
            cal.setTimeInMillis(DateFormatter.extractTimestamp(value).getTime());
        }
        return DateFormatter.formatDate(cal);
    }

    public static String formatDateTime(Object value, Timestamp ts) {
        Calendar cal = value instanceof Long ? calendarUTCThreadLocal.get() : calendarThreadLocal.get();
        cal.setTimeInMillis(ts.getTime());
        return DateFormatter.formatDateTime(cal);
    }

    private static long floorDiv(long a, long b) {
        return (a < 0L ? a - (b - 1L) : a) / b;
    }

    private static long floorMod(long x, long y) {
        return x - DateFormatter.floorDiv(x, y) * y;
    }
}

