/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonBinary;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.row.RawJSONString;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import java.io.IOException;

public class JsonColumnDef
extends ColumnDef {
    private JsonColumnDef(String name, String type, short pos) {
        super(name, type, pos);
    }

    public static JsonColumnDef create(String name, String type, short pos) {
        JsonColumnDef temp = new JsonColumnDef(name, type, pos);
        return (JsonColumnDef)INTERNER.intern((Object)temp);
    }

    @Override
    public Object asJSON(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        if (value instanceof String) {
            return new RawJSONString((String)value);
        }
        if (value instanceof byte[]) {
            try {
                byte[] bytes = (byte[])value;
                String jsonString = bytes.length > 0 ? JsonBinary.parseAsString((byte[])bytes) : "null";
                return new RawJSONString(jsonString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new ColumnDefCastException(this, value);
    }

    @Override
    public String toSQL(Object value) {
        return null;
    }
}

