/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import com.zendesk.maxwell.schema.columndef.ColumnDefWithLength;
import java.sql.Time;
import java.sql.Timestamp;

public class TimeColumnDef
extends ColumnDefWithLength {
    private TimeColumnDef(String name, String type, short pos, Long columnLength) {
        super(name, type, pos, columnLength);
    }

    public static TimeColumnDef create(String name, String type, short pos, Long columnLength) {
        TimeColumnDef temp = new TimeColumnDef(name, type, pos, columnLength);
        return (TimeColumnDef)INTERNER.intern((Object)temp);
    }

    @Override
    protected String formatValue(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        if (value instanceof Timestamp) {
            Time time = new Time(((Timestamp)value).getTime());
            String timeAsStr = String.valueOf(time);
            return TimeColumnDef.appendFractionalSeconds(timeAsStr, ((Timestamp)value).getNanos(), this.getColumnLength());
        }
        if (value instanceof Long) {
            Time time = new Time((Long)value / 1000L);
            String timeAsStr = String.valueOf(time);
            return TimeColumnDef.appendFractionalSeconds(timeAsStr, (int)((Long)value % 1000000L) * 1000, this.getColumnLength());
        }
        if (value instanceof Time) {
            return String.valueOf((Time)value);
        }
        throw new ColumnDefCastException(this, value);
    }
}

