/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;

public class ResolvedDatabaseCreate
extends ResolvedSchemaChange {
    public String database;
    public String charset;

    public ResolvedDatabaseCreate() {
    }

    public ResolvedDatabaseCreate(String database, String charset) {
        this.database = database;
        this.charset = charset;
    }

    @Override
    public void apply(Schema schema) throws InvalidSchemaError {
        if (schema.hasDatabase(this.database)) {
            throw new InvalidSchemaError("Unexpectedly asked to create existing database " + this.database);
        }
        schema.addDatabase(new Database(this.database, this.charset));
    }

    @Override
    public String databaseName() {
        return this.database;
    }

    @Override
    public String tableName() {
        return null;
    }
}

