/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.ddl.ResolvedTableDrop;
import com.zendesk.maxwell.schema.ddl.SchemaChange;

public class TableDrop
extends SchemaChange {
    public String database;
    final String table;
    final boolean ifExists;

    public TableDrop(String database, String table, boolean ifExists) {
        this.database = database;
        this.table = table;
        this.ifExists = ifExists;
    }

    @Override
    public ResolvedTableDrop resolve(Schema schema) {
        Database d;
        if (this.ifExists && ((d = schema.findDatabase(this.database)) == null || !d.hasTable(this.table))) {
            return null;
        }
        return new ResolvedTableDrop(this.database, this.table);
    }

    @Override
    public boolean isBlacklisted(Filter filter) {
        if (filter == null) {
            return false;
        }
        return filter.isTableBlacklisted(this.database, this.table);
    }
}

