/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import com.zendesk.maxwell.util.StoppableTask;
import com.zendesk.maxwell.util.StoppableTaskState;
import java.util.concurrent.TimeoutException;

public abstract class RunLoopProcess
implements StoppableTask {
    protected volatile StoppableTaskState taskState = new StoppableTaskState(this.getClass().getName());
    private Thread thread;

    @Override
    public void requestStop() {
        this.taskState.requestStop();
        this.interrupt();
    }

    public void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void awaitStop(Long timeout) throws TimeoutException {
        this.taskState.awaitStop(this.thread, timeout);
    }

    public void runLoop() throws Exception {
        this.thread = Thread.currentThread();
        this.beforeStart();
        try {
            while (this.taskState.isRunning()) {
                this.work();
            }
        }
        finally {
            this.beforeStop();
            this.taskState.stopped();
        }
    }

    protected abstract void work() throws Exception;

    protected void beforeStart() throws Exception {
    }

    protected void beforeStop() throws Exception {
    }
}

