/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import com.zendesk.maxwell.row.RowIdentity;
import com.zendesk.maxwell.row.RowMap;

public class TopicInterpolator {
    private final String inputString;
    private final boolean isInterpolated;

    public TopicInterpolator(String templateString) {
        this.inputString = templateString;
        this.isInterpolated = templateString.contains("%{");
    }

    public String generateFromRowIdentity(RowIdentity pk) {
        String table = pk.getTable();
        if (this.isInterpolated) {
            return this.interpolate(pk.getDatabase(), table, null, false);
        }
        return this.inputString;
    }

    public String generateFromRowMap(RowMap r) {
        String table = r.getTable();
        String type = r.getRowType();
        if (this.isInterpolated) {
            return this.interpolate(r.getDatabase(), table, type, false);
        }
        return this.inputString;
    }

    public String generateFromRowMapAndCleanUpIllegalCharacters(RowMap r) {
        String table = r.getTable();
        String type = r.getRowType();
        if (this.isInterpolated) {
            return this.interpolate(r.getDatabase(), table, type, true).replaceAll("\\s+", "");
        }
        return this.inputString;
    }

    protected String interpolate(String database, String table, String type, Boolean cleanUpIllegalCharacters) {
        if (this.isInterpolated) {
            String typeReplacement;
            String string = typeReplacement = type != null ? type : "";
            if (cleanUpIllegalCharacters.booleanValue()) {
                return this.inputString.replaceAll("%\\{database\\}", this.cleanupIllegalCharacters(this.emptyStringOnNull(database))).replaceAll("%\\{table\\}", this.cleanupIllegalCharacters(this.emptyStringOnNull(table))).replaceAll("%\\{type\\}", this.cleanupIllegalCharacters(this.emptyStringOnNull(typeReplacement)));
            }
            return this.inputString.replaceAll("%\\{database\\}", this.emptyStringOnNull(database)).replaceAll("%\\{table\\}", this.emptyStringOnNull(table)).replaceAll("%\\{type\\}", this.emptyStringOnNull(typeReplacement));
        }
        return this.inputString;
    }

    private String emptyStringOnNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private String cleanupIllegalCharacters(String value) {
        return value.replaceAll("([^A-Za-z0-9])", "_");
    }
}

