/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell;

import com.djdch.log4j.StaticShutdownCallbackRegistry;
import com.github.shyiko.mysql.binlog.network.ServerException;
import com.zendesk.maxwell.MaxwellConfig;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.MaxwellHA;
import com.zendesk.maxwell.MaxwellMysqlStatus;
import com.zendesk.maxwell.bootstrap.BootstrapController;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.recovery.Recovery;
import com.zendesk.maxwell.recovery.RecoveryInfo;
import com.zendesk.maxwell.replication.BinlogConnectorReplicator;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.replication.Replicator;
import com.zendesk.maxwell.row.HeartbeatRowMap;
import com.zendesk.maxwell.schema.MysqlPositionStore;
import com.zendesk.maxwell.schema.MysqlSchemaStore;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.SchemaCapturer;
import com.zendesk.maxwell.schema.SchemaStoreException;
import com.zendesk.maxwell.schema.SchemaStoreSchema;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import com.zendesk.maxwell.util.Logging;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Maxwell
implements Runnable {
    protected MaxwellConfig config;
    protected MaxwellContext context;
    protected Replicator replicator;
    static final Logger LOGGER = LoggerFactory.getLogger(Maxwell.class);
    static String bootString = "Maxwell v%s is booting (%s), starting at %s";

    public Maxwell(MaxwellConfig config) throws SQLException, URISyntaxException {
        this(new MaxwellContext(config));
    }

    protected Maxwell(MaxwellContext context) throws SQLException, URISyntaxException {
        this.config = context.getConfig();
        this.context = context;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (Exception e) {
            LOGGER.error("maxwell encountered an exception", (Throwable)e);
        }
    }

    public void restart() throws Exception {
        this.context = new MaxwellContext(this.config);
        this.start();
    }

    public void terminate() {
        Thread terminationThread = this.context.terminate();
        if (terminationThread != null) {
            try {
                terminationThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Position attemptMasterRecovery() throws Exception {
        Recovery masterRecovery;
        HeartbeatRowMap recoveredHeartbeat = null;
        MysqlPositionStore positionStore = this.context.getPositionStore();
        RecoveryInfo recoveryInfo = positionStore.getRecoveryInfo(this.config);
        if (recoveryInfo != null && (recoveredHeartbeat = (masterRecovery = new Recovery(this.config.replicationMysql, this.config.databaseName, this.context.getReplicationConnectionPool(), this.context.getCaseSensitivity(), recoveryInfo)).recover()) != null) {
            MysqlSchemaStore oldServerSchemaStore = new MysqlSchemaStore(this.context.getMaxwellConnectionPool(), this.context.getReplicationConnectionPool(), this.context.getSchemaConnectionPool(), recoveryInfo.serverID, recoveryInfo.position, this.context.getCaseSensitivity(), this.config.filter, false);
            oldServerSchemaStore.clone(this.context.getServerID(), recoveredHeartbeat.getPosition());
            return recoveredHeartbeat.getNextPosition();
        }
        return null;
    }

    private void logColumnCastError(ColumnDefCastException e) throws SQLException, SchemaStoreException {
        LOGGER.error("checking for schema inconsistencies in " + e.database + "." + e.table);
        try (Connection conn = this.context.getSchemaConnectionPool().getConnection();
             SchemaCapturer capturer = new SchemaCapturer(conn, this.context.getCaseSensitivity(), e.database, e.table);){
            Schema recaptured = capturer.capture();
            Table t = this.replicator.getSchema().findDatabase(e.database).findTable(e.table);
            ArrayList<String> diffs = new ArrayList<String>();
            t.diff(diffs, recaptured.findDatabase(e.database).findTable(e.table), "old", "new");
            if (diffs.size() == 0) {
                LOGGER.error("no differences found");
            } else {
                for (String diff : diffs) {
                    LOGGER.error(diff);
                }
            }
        }
    }

    protected Position getInitialPosition() throws Exception {
        Position initial = this.context.getInitialPosition();
        if (initial == null) {
            if (this.config.masterRecovery) {
                initial = this.attemptMasterRecovery();
            }
            if (initial == null && (initial = this.context.getOtherClientPosition()) != null) {
                LOGGER.info("Found previous client position: " + initial);
            }
            if (initial == null) {
                try (Connection c = this.context.getReplicationConnection();){
                    initial = Position.capture(c, this.config.gtidMode);
                }
            }
            this.context.getPositionStore().set(initial);
        }
        if (this.config.masterRecovery) {
            this.context.getPositionStore().cleanupOldRecoveryInfos();
        }
        return initial;
    }

    public String getMaxwellVersion() {
        String packageVersion = this.getClass().getPackage().getImplementationVersion();
        if (packageVersion == null) {
            return "??";
        }
        return packageVersion;
    }

    private void logBanner(AbstractProducer producer, Position initialPosition) {
        String producerName = producer.getClass().getSimpleName();
        LOGGER.info(String.format(bootString, this.getMaxwellVersion(), producerName, initialPosition.toString()));
    }

    protected void onReplicatorStart() {
    }

    protected void onReplicatorEnd() {
    }

    public void start() throws Exception {
        try {
            this.startInner();
        }
        catch (Exception e) {
            this.context.terminate(e);
        }
        finally {
            this.onReplicatorEnd();
            this.terminate();
        }
        Exception error = this.context.getError();
        if (error != null) {
            throw error;
        }
    }

    private void startInner() throws Exception {
        try (Connection connection = this.context.getReplicationConnection();
             Connection rawConnection = this.context.getRawMaxwellConnection();){
            MaxwellMysqlStatus.ensureReplicationMysqlState(connection);
            MaxwellMysqlStatus.ensureMaxwellMysqlState(rawConnection);
            if (this.config.gtidMode.booleanValue()) {
                MaxwellMysqlStatus.ensureGtidMysqlState(connection);
            }
            SchemaStoreSchema.ensureMaxwellSchema(rawConnection, this.config.databaseName);
            try (Connection schemaConnection = this.context.getMaxwellConnection();){
                SchemaStoreSchema.upgradeSchemaStoreSchema(schemaConnection);
            }
        }
        AbstractProducer producer = this.context.getProducer();
        Position initPosition = this.getInitialPosition();
        this.logBanner(producer, initPosition);
        this.context.setPosition(initPosition);
        MysqlSchemaStore mysqlSchemaStore = new MysqlSchemaStore(this.context, initPosition);
        BootstrapController bootstrapController = this.context.getBootstrapController(mysqlSchemaStore.getSchemaID());
        this.context.startSchemaCompactor();
        if (this.config.recaptureSchema) {
            mysqlSchemaStore.captureAndSaveSchema();
        }
        mysqlSchemaStore.getSchema();
        this.replicator = new BinlogConnectorReplicator(mysqlSchemaStore, producer, bootstrapController, this.config.replicationMysql, this.config.replicaServerID, this.config.databaseName, this.context.getMetrics(), initPosition, false, this.config.clientID, this.context.getHeartbeatNotifier(), this.config.scripting, this.context.getFilter(), this.context.getConfig().getIgnoreMissingSchema(), this.config.outputConfig, this.config.bufferMemoryUsage, this.config.replicationReconnectionRetries, this.config.binlogEventQueueSize);
        this.context.setReplicator(this.replicator);
        this.context.start();
        this.replicator.startReplicator();
        this.onReplicatorStart();
        try {
            this.replicator.runLoop();
        }
        catch (ColumnDefCastException e) {
            this.logColumnCastError(e);
        }
    }

    public static void main(String[] args) {
        try {
            Logging.setupLogBridging();
            MaxwellConfig config = new MaxwellConfig(args);
            if (config.log_level != null) {
                Logging.setLevel(config.log_level);
            }
            final Maxwell maxwell = new Maxwell(config);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    maxwell.terminate();
                    StaticShutdownCallbackRegistry.invoke();
                }
            });
            LOGGER.info("Starting Maxwell. maxMemory: " + Runtime.getRuntime().maxMemory() + " bufferMemoryUsage: " + config.bufferMemoryUsage);
            if (config.haMode) {
                new MaxwellHA(maxwell, config.jgroupsConf, config.raftMemberID, config.clientID).startHA();
            } else {
                maxwell.start();
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQLException: " + e.getLocalizedMessage(), (Throwable)e);
            System.exit(1);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Syntax issue with URI, check for misconfigured host, port, database, or JDBC options (see RFC 2396)");
            LOGGER.error("URISyntaxException: " + e.getLocalizedMessage(), (Throwable)e);
            System.exit(1);
        }
        catch (ServerException e) {
            LOGGER.error("Maxwell couldn't find the requested binlog, exiting...", (Throwable)e);
            System.exit(2);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Maxwell saw an exception and is exiting...", (Throwable)e);
            System.exit(1);
        }
    }
}

