/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.MaxwellConfig;
import com.zendesk.maxwell.MaxwellMysqlStatus;
import com.zendesk.maxwell.bootstrap.BootstrapController;
import com.zendesk.maxwell.bootstrap.SynchronousBootstrapper;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.monitoring.MaxwellDiagnostic;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticContext;
import com.zendesk.maxwell.monitoring.MaxwellHTTPServer;
import com.zendesk.maxwell.monitoring.MaxwellMetrics;
import com.zendesk.maxwell.monitoring.Metrics;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.producer.BufferedProducer;
import com.zendesk.maxwell.producer.FileProducer;
import com.zendesk.maxwell.producer.MaxwellBigQueryProducer;
import com.zendesk.maxwell.producer.MaxwellKafkaProducer;
import com.zendesk.maxwell.producer.MaxwellKinesisProducer;
import com.zendesk.maxwell.producer.MaxwellPubsubProducer;
import com.zendesk.maxwell.producer.MaxwellRedisProducer;
import com.zendesk.maxwell.producer.MaxwellSNSProducer;
import com.zendesk.maxwell.producer.MaxwellSQSProducer;
import com.zendesk.maxwell.producer.NatsProducer;
import com.zendesk.maxwell.producer.NoneProducer;
import com.zendesk.maxwell.producer.ProfilerProducer;
import com.zendesk.maxwell.producer.RabbitmqProducer;
import com.zendesk.maxwell.producer.StdoutProducer;
import com.zendesk.maxwell.recovery.RecoveryInfo;
import com.zendesk.maxwell.replication.BinlogConnectorDiagnostic;
import com.zendesk.maxwell.replication.HeartbeatNotifier;
import com.zendesk.maxwell.replication.MysqlVersion;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.replication.Replicator;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.schema.MysqlPositionStore;
import com.zendesk.maxwell.schema.MysqlSchemaCompactor;
import com.zendesk.maxwell.schema.PositionStoreThread;
import com.zendesk.maxwell.schema.ReadOnlyMysqlPositionStore;
import com.zendesk.maxwell.util.C3P0ConnectionPool;
import com.zendesk.maxwell.util.ConnectionPool;
import com.zendesk.maxwell.util.RunLoopProcess;
import com.zendesk.maxwell.util.StoppableTask;
import com.zendesk.maxwell.util.TaskManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellContext {
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellContext.class);
    private ConnectionPool replicationConnectionPool;
    private ConnectionPool maxwellConnectionPool;
    private ConnectionPool rawMaxwellConnectionPool;
    private final ConnectionPool schemaConnectionPool;
    private final MaxwellConfig config;
    private final MaxwellMetrics metrics;
    private final MysqlPositionStore positionStore;
    private PositionStoreThread positionStoreThread;
    private Long serverID;
    private Position initialPosition;
    private CaseSensitivity caseSensitivity;
    private AbstractProducer producer;
    private final TaskManager taskManager;
    private volatile Exception error;
    private MysqlVersion mysqlVersion;
    private Replicator replicator;
    private Thread terminationThread;
    private final HeartbeatNotifier heartbeatNotifier;
    private final MaxwellDiagnosticContext diagnosticContext;
    private BootstrapController bootstrapController;
    private Thread bootstrapControllerThread;
    private Boolean isMariaDB;
    public MetricRegistry metricRegistry;
    public HealthCheckRegistry healthCheckRegistry;

    public MaxwellContext(MaxwellConfig config) throws SQLException, URISyntaxException {
        this.config = config;
        this.config.validate();
        this.taskManager = new TaskManager();
        this.metricRegistry = config.metricRegistry;
        if (this.metricRegistry == null) {
            this.metricRegistry = new MetricRegistry();
        }
        this.metrics = new MaxwellMetrics(config, this.metricRegistry);
        this.replicationConnectionPool = new C3P0ConnectionPool(config.replicationMysql.getConnectionURI(false), config.replicationMysql.user, config.replicationMysql.password);
        this.replicationConnectionPool.probe();
        if (config.schemaMysql.host == null) {
            this.schemaConnectionPool = null;
        } else {
            this.schemaConnectionPool = new C3P0ConnectionPool(config.schemaMysql.getConnectionURI(false), config.schemaMysql.user, config.schemaMysql.password);
            this.schemaConnectionPool.probe();
        }
        this.rawMaxwellConnectionPool = new C3P0ConnectionPool(config.maxwellMysql.getConnectionURI(false), config.maxwellMysql.user, config.maxwellMysql.password);
        this.rawMaxwellConnectionPool.probe();
        this.maxwellConnectionPool = new C3P0ConnectionPool(config.maxwellMysql.getConnectionURI(), config.maxwellMysql.user, config.maxwellMysql.password);
        if (this.config.initPosition != null) {
            this.initialPosition = this.config.initPosition;
        }
        this.positionStore = this.config.replayMode ? new ReadOnlyMysqlPositionStore(this.getMaxwellConnectionPool(), this.getServerID(), this.config.clientID, config.gtidMode) : new MysqlPositionStore(this.getMaxwellConnectionPool(), this.getServerID(), this.config.clientID, config.gtidMode);
        this.heartbeatNotifier = new HeartbeatNotifier();
        ArrayList<MaxwellDiagnostic> diagnostics = new ArrayList<MaxwellDiagnostic>(Collections.singletonList(new BinlogConnectorDiagnostic(this)));
        this.diagnosticContext = new MaxwellDiagnosticContext(config.diagnosticConfig, diagnostics);
        this.healthCheckRegistry = config.healthCheckRegistry;
        if (this.healthCheckRegistry == null) {
            this.healthCheckRegistry = new HealthCheckRegistry();
        }
    }

    public MaxwellConfig getConfig() {
        return this.config;
    }

    public Connection getReplicationConnection() throws SQLException {
        return this.replicationConnectionPool.getConnection();
    }

    public ConnectionPool getReplicationConnectionPool() {
        return this.replicationConnectionPool;
    }

    public ConnectionPool getMaxwellConnectionPool() {
        return this.maxwellConnectionPool;
    }

    public ConnectionPool getSchemaConnectionPool() {
        if (this.schemaConnectionPool != null) {
            return this.schemaConnectionPool;
        }
        return this.replicationConnectionPool;
    }

    public Connection getMaxwellConnection() throws SQLException {
        return this.maxwellConnectionPool.getConnection();
    }

    public Connection getRawMaxwellConnection() throws SQLException {
        return this.rawMaxwellConnectionPool.getConnection();
    }

    public void start() throws IOException {
        MaxwellHTTPServer.startIfRequired(this);
        this.getPositionStoreThread();
    }

    public long heartbeat() throws Exception {
        return this.positionStore.heartbeat();
    }

    public void addTask(StoppableTask task) {
        this.taskManager.add(task);
    }

    public Thread terminate() {
        return this.terminate(null);
    }

    public Thread terminate(Exception error) {
        if (this.error == null) {
            this.error = error;
        }
        if (this.taskManager.requestStop()) {
            if (this.error == null && this.replicator != null) {
                this.sendFinalHeartbeat();
            }
            this.terminationThread = this.spawnTerminateThread();
        }
        return this.terminationThread;
    }

    private void sendFinalHeartbeat() {
        long heartbeat = System.currentTimeMillis();
        LOGGER.info("Sending final heartbeat: " + heartbeat);
        try {
            this.replicator.stopAtHeartbeat(heartbeat);
            this.positionStore.heartbeat(heartbeat);
            long deadline = heartbeat + 5000L;
            while (this.positionStoreThread.getPosition().getLastHeartbeatRead() < heartbeat) {
                if (System.currentTimeMillis() > deadline) {
                    LOGGER.warn("Timed out waiting for heartbeat " + heartbeat);
                    break;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to send final heartbeat", (Throwable)e);
        }
    }

    private void shutdown(AtomicBoolean complete) {
        try {
            this.taskManager.stop(this.error);
            this.metrics.stop();
            this.replicationConnectionPool.release();
            this.replicationConnectionPool = null;
            this.maxwellConnectionPool.release();
            this.maxwellConnectionPool = null;
            this.rawMaxwellConnectionPool.release();
            this.rawMaxwellConnectionPool = null;
            complete.set(true);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred during shutdown:", (Throwable)e);
        }
    }

    private Thread spawnTerminateThread() {
        final AtomicBoolean shutdownComplete = new AtomicBoolean(false);
        final MaxwellContext self = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread shutdownThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        self.shutdown(shutdownComplete);
                    }
                }, "shutdownThread");
                shutdownThread.start();
                try {
                    shutdownThread.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean isShutdownComplete = shutdownComplete.get();
                LOGGER.debug("Shutdown complete: {}", (Object)isShutdownComplete);
                if (!isShutdownComplete) {
                    LOGGER.error("Shutdown stalled - forcefully killing maxwell process");
                    if (self.error != null) {
                        LOGGER.error("Termination reason:", (Throwable)self.error);
                    }
                    Runtime.getRuntime().halt(1);
                }
            }
        }, "shutdownMonitor");
        thread.setDaemon(false);
        thread.start();
        return thread;
    }

    private Thread startTask(RunLoopProcess task, String name) {
        Thread t = new Thread(() -> {
            try {
                task.runLoop();
            }
            catch (Exception e) {
                LOGGER.error("exception in thread: " + name, (Throwable)e);
                try {
                    this.terminate(e);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }, name);
        t.start();
        this.addTask(task);
        return t;
    }

    public Exception getError() {
        return this.error;
    }

    public PositionStoreThread getPositionStoreThread() {
        if (this.positionStoreThread == null) {
            this.positionStoreThread = new PositionStoreThread(this.positionStore, this);
            this.positionStoreThread.start();
            this.addTask(this.positionStoreThread);
        }
        return this.positionStoreThread;
    }

    public Position getInitialPosition() throws SQLException {
        if (this.initialPosition != null) {
            return this.initialPosition;
        }
        this.initialPosition = this.positionStore.get();
        return this.initialPosition;
    }

    public Position getOtherClientPosition() throws SQLException {
        return this.positionStore.getLatestFromAnyClient();
    }

    public RecoveryInfo getRecoveryInfo() throws SQLException {
        return this.positionStore.getRecoveryInfo(this.config);
    }

    public void setPosition(RowMap r) {
        if (r.isTXCommit()) {
            this.setPosition(r.getNextPosition());
        }
    }

    public void setPosition(Position position) {
        if (position == null) {
            return;
        }
        this.getPositionStoreThread().setPosition(position);
    }

    public Position getPosition() throws SQLException {
        return this.getPositionStoreThread().getPosition();
    }

    public MysqlPositionStore getPositionStore() {
        return this.positionStore;
    }

    /*
     * Exception decompiling
     */
    public Long getServerID() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MysqlVersion getMysqlVersion() throws SQLException {
        if (this.mysqlVersion == null) {
            try (Connection c = this.getReplicationConnection();){
                this.mysqlVersion = MysqlVersion.capture(c);
            }
        }
        return this.mysqlVersion;
    }

    public CaseSensitivity getCaseSensitivity() throws SQLException {
        if (this.caseSensitivity == null) {
            try (Connection c = this.getReplicationConnection();){
                this.caseSensitivity = MaxwellMysqlStatus.captureCaseSensitivity(c);
            }
        }
        return this.caseSensitivity;
    }

    public AbstractProducer getProducer() throws IOException {
        if (this.producer != null) {
            return this.producer;
        }
        if (this.config.producerFactory != null) {
            this.producer = this.config.producerFactory.createProducer(this);
        } else {
            switch (this.config.producerType) {
                case "file": {
                    this.producer = new FileProducer(this, this.config.outputFile);
                    break;
                }
                case "kafka": {
                    this.producer = new MaxwellKafkaProducer(this, this.config.getKafkaProperties(), this.config.kafkaTopic);
                    break;
                }
                case "kinesis": {
                    this.producer = new MaxwellKinesisProducer(this, this.config.kinesisStream);
                    break;
                }
                case "sqs": {
                    this.producer = new MaxwellSQSProducer(this, this.config.sqsQueueUri, this.config.sqsServiceEndpoint, this.config.sqsSigningRegion);
                    break;
                }
                case "sns": {
                    this.producer = new MaxwellSNSProducer(this, this.config.snsTopic);
                    break;
                }
                case "nats": {
                    this.producer = new NatsProducer(this);
                    break;
                }
                case "pubsub": {
                    this.producer = new MaxwellPubsubProducer(this, this.config.pubsubProjectId, this.config.pubsubTopic, this.config.ddlPubsubTopic, this.config.pubsubMessageOrderingKey, this.config.pubsubEmulator);
                    break;
                }
                case "profiler": {
                    this.producer = new ProfilerProducer(this);
                    break;
                }
                case "stdout": {
                    this.producer = new StdoutProducer(this);
                    break;
                }
                case "buffer": {
                    this.producer = new BufferedProducer(this, this.config.bufferedProducerSize);
                    break;
                }
                case "rabbitmq": {
                    this.producer = new RabbitmqProducer(this);
                    break;
                }
                case "redis": {
                    this.producer = new MaxwellRedisProducer(this);
                    break;
                }
                case "bigquery": {
                    this.producer = new MaxwellBigQueryProducer(this, this.config.bigQueryProjectId, this.config.bigQueryDataset, this.config.bigQueryTable);
                    break;
                }
                case "none": {
                    this.producer = new NoneProducer(this);
                    break;
                }
                case "custom": {
                    throw new RuntimeException("Please specify --custom_producer.factory!");
                }
                default: {
                    throw new RuntimeException("Unknown producer type: " + this.config.producerType);
                }
            }
        }
        if (this.producer != null && this.producer.getDiagnostic() != null) {
            this.diagnosticContext.diagnostics.add(this.producer.getDiagnostic());
        }
        StoppableTask task = null;
        if (this.producer != null) {
            task = this.producer.getStoppableTask();
        }
        if (task != null) {
            this.addTask(task);
        }
        return this.producer;
    }

    public void runBootstrapNow() {
        if (this.bootstrapControllerThread != null) {
            this.bootstrapControllerThread.interrupt();
        }
    }

    public synchronized BootstrapController getBootstrapController(Long currentSchemaID) throws IOException {
        if (this.bootstrapController != null) {
            return this.bootstrapController;
        }
        if (this.config.bootstrapperType.equals("none")) {
            return null;
        }
        SynchronousBootstrapper bootstrapper = new SynchronousBootstrapper(this);
        this.bootstrapController = new BootstrapController(this.getMaxwellConnectionPool(), this.getProducer(), bootstrapper, this.config.clientID, this.config.bootstrapperType.equals("sync"), currentSchemaID);
        this.bootstrapControllerThread = this.startTask(this.bootstrapController, "maxwell-bootstrap-controller");
        return this.bootstrapController;
    }

    public void startSchemaCompactor() throws SQLException {
        if (this.config.maxSchemaDeltas == null) {
            return;
        }
        MysqlSchemaCompactor compactor = new MysqlSchemaCompactor(this.config.maxSchemaDeltas, this.getMaxwellConnectionPool(), this.config.clientID, this.getServerID(), this.getCaseSensitivity());
        this.startTask(compactor, "maxwell-schema-compactor");
    }

    public Filter getFilter() {
        return this.config.filter;
    }

    public boolean getReplayMode() {
        return this.config.replayMode;
    }

    public void setReplicator(Replicator replicator) {
        this.addTask(replicator);
        this.replicator = replicator;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public HeartbeatNotifier getHeartbeatNotifier() {
        return this.heartbeatNotifier;
    }

    public MaxwellDiagnosticContext getDiagnosticContext() {
        return this.diagnosticContext;
    }

    public boolean isMariaDB() {
        if (this.isMariaDB == null) {
            try (Connection c = this.getReplicationConnection();){
                this.isMariaDB = MaxwellMysqlStatus.isMaria(c);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return this.isMariaDB;
    }
}

