/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.filtering;

import com.zendesk.maxwell.filtering.FilterParser;
import com.zendesk.maxwell.filtering.FilterPattern;
import com.zendesk.maxwell.filtering.FilterPatternType;
import com.zendesk.maxwell.filtering.FilterResult;
import com.zendesk.maxwell.filtering.InvalidFilterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filter {
    static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);
    private final List<FilterPattern> patterns = new ArrayList<FilterPattern>();
    private String maxwellDB = "maxwell";

    public Filter() {
    }

    public Filter(String filterString) throws InvalidFilterException {
        this();
        this.patterns.addAll(new FilterParser(filterString).parse());
    }

    public Filter(String maxwellDB, String filterString) throws InvalidFilterException {
        this();
        this.maxwellDB = maxwellDB;
        this.patterns.addAll(new FilterParser(filterString).parse());
    }

    public String toString() {
        return this.patterns.stream().map(FilterPattern::toString).collect(Collectors.joining(", "));
    }

    public void set(String filterString) throws InvalidFilterException {
        List<FilterPattern> parsedFilter = new FilterParser(filterString).parse();
        this.patterns.clear();
        this.patterns.addAll(parsedFilter);
    }

    public boolean isSystemWhitelisted(String database, String table) {
        return this.isMaxwellDB(database) && ("bootstrap".equals(table) || "heartbeats".equals(table));
    }

    public boolean isMaxwellDB(String database) {
        return this.maxwellDB.equals(database);
    }

    public void addRule(String filterString) throws InvalidFilterException {
        this.patterns.addAll(new FilterParser(filterString).parse());
    }

    public List<FilterPattern> getRules() {
        return new ArrayList<FilterPattern>(this.patterns);
    }

    public boolean includes(String database, String table) {
        FilterResult match = new FilterResult();
        for (FilterPattern p : this.patterns) {
            p.match(database, table, match);
        }
        return match.include;
    }

    public boolean includes(String database, String table, Map<String, Object> values) {
        FilterResult match = new FilterResult();
        for (FilterPattern p : this.patterns) {
            p.matchValue(database, table, values, match);
        }
        return match.include;
    }

    public boolean couldIncludeFromColumnFilters(String database, String table, Set<String> columns) {
        for (FilterPattern p : this.patterns) {
            if (!p.couldIncludeColumn(database, table, columns)) continue;
            return true;
        }
        return false;
    }

    public boolean isTableBlacklisted(String database, String table) {
        if (Filter.isSystemBlacklisted(database, table)) {
            return true;
        }
        if (this.isMaxwellDB(database)) {
            return false;
        }
        FilterResult match = new FilterResult();
        for (FilterPattern p : this.patterns) {
            if (p.getType() != FilterPatternType.BLACKLIST) continue;
            p.match(database, table, match);
        }
        return !match.include;
    }

    public boolean isDatabaseBlacklisted(String database) {
        if (this.isMaxwellDB(database)) {
            return false;
        }
        for (FilterPattern p : this.patterns) {
            if (p.getType() != FilterPatternType.BLACKLIST || !p.getDatabasePattern().matcher(database).find() || !p.getTablePattern().toString().equals("")) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemBlacklisted(String databaseName, String tableName) {
        return "mysql".equals(databaseName) && ("ha_health_check".equals(tableName) || StringUtils.startsWith((CharSequence)tableName, (CharSequence)"rds_heartbeat"));
    }

    public static boolean includes(Filter filter, String database, String table) {
        if (filter == null) {
            return true;
        }
        return filter.includes(database, table);
    }

    public static boolean includes(Filter filter, String database, String table, Map<String, Object> data) {
        if (filter == null) {
            return true;
        }
        return filter.includes(database, table, data);
    }

    public static boolean couldIncludeFromColumnFilters(Filter filter, String database, String table, Set<String> columnNames) {
        if (filter == null) {
            return false;
        }
        return filter.couldIncludeFromColumnFilters(database, table, columnNames);
    }
}

