/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.filtering;

import com.amazonaws.util.StringInputStream;
import com.zendesk.maxwell.filtering.FilterColumnPattern;
import com.zendesk.maxwell.filtering.FilterPattern;
import com.zendesk.maxwell.filtering.FilterPatternType;
import com.zendesk.maxwell.filtering.InvalidFilterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FilterParser {
    private StreamTokenizer tokenizer;
    private InputStreamReader inputStream;
    private final String input;

    public FilterParser(String input) {
        this.input = input;
    }

    public List<FilterPattern> parse() throws InvalidFilterException {
        try {
            this.inputStream = new InputStreamReader((InputStream)new StringInputStream(this.input));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidFilterException(e.getMessage());
        }
        this.tokenizer = new StreamTokenizer(this.inputStream);
        try {
            return this.doParse();
        }
        catch (IOException e) {
            throw new InvalidFilterException(e.getMessage());
        }
    }

    private List<FilterPattern> doParse() throws IOException {
        FilterPattern p;
        ArrayList<FilterPattern> patterns = new ArrayList<FilterPattern>();
        this.tokenizer.ordinaryChar(46);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.ordinaryChars(48, 57);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.quoteChar(96);
        this.tokenizer.quoteChar(39);
        this.tokenizer.quoteChar(34);
        this.tokenizer.nextToken();
        while ((p = this.parseFilterPattern()) != null) {
            patterns.add(p);
        }
        return patterns;
    }

    private void skipToken(char token) throws IOException {
        if (this.tokenizer.ttype != token) {
            throw new IOException("Expected '" + token + "', saw: " + this.tokenizer.toString());
        }
        this.tokenizer.nextToken();
    }

    private FilterPattern parseFilterPattern() throws IOException {
        FilterPattern ret;
        FilterPatternType type;
        if (this.tokenizer.ttype == -1) {
            return null;
        }
        if (this.tokenizer.ttype != -3) {
            throw new IOException("expected [include, exclude, blacklist] in filter definition.");
        }
        switch (this.tokenizer.sval.toLowerCase()) {
            case "include": {
                type = FilterPatternType.INCLUDE;
                break;
            }
            case "exclude": {
                type = FilterPatternType.EXCLUDE;
                break;
            }
            case "blacklist": {
                type = FilterPatternType.BLACKLIST;
                break;
            }
            default: {
                throw new IOException("Unknown filter keyword: " + this.tokenizer.sval);
            }
        }
        this.tokenizer.nextToken();
        this.skipToken(':');
        Pattern dbPattern = this.parsePattern();
        this.skipToken('.');
        Pattern tablePattern = this.parsePattern();
        if (this.tokenizer.ttype == 46) {
            this.tokenizer.nextToken();
            if (this.tokenizer.ttype != -3) {
                throw new IOException("expected column name, got" + this.tokenizer.nextToken());
            }
            String columnName = this.tokenizer.sval;
            this.tokenizer.nextToken();
            this.skipToken('=');
            Pattern valuePattern = this.parsePattern();
            ret = new FilterColumnPattern(type, dbPattern, tablePattern, columnName, valuePattern);
        } else {
            ret = new FilterPattern(type, dbPattern, tablePattern);
        }
        if (this.tokenizer.ttype == 44) {
            this.tokenizer.nextToken();
        }
        return ret;
    }

    private Pattern parsePattern() throws IOException {
        Pattern pattern;
        switch (this.tokenizer.ttype) {
            case 47: {
                pattern = Pattern.compile(this.parseRegexp());
                break;
            }
            case 42: {
                pattern = Pattern.compile("");
                break;
            }
            case -3: 
            case 34: 
            case 39: 
            case 96: {
                pattern = Pattern.compile("^" + this.tokenizer.sval + "$");
                break;
            }
            default: {
                throw new IOException("Expected string or regexp, saw '" + Character.toString((char)this.tokenizer.ttype));
            }
        }
        this.tokenizer.nextToken();
        return pattern;
    }

    private String parseRegexp() throws IOException {
        char ch;
        int lastChar = 0;
        Object s = "";
        while ((ch = (char)this.inputStream.read()) != '/' || lastChar == 92) {
            s = (String)s + ch;
            lastChar = ch;
        }
        return s;
    }
}

