/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.PingServlet;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.monitoring.DiagnosticHealthCheck;
import com.zendesk.maxwell.monitoring.IndexListServlet;
import com.zendesk.maxwell.monitoring.MaxwellConfigServlet;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticContext;
import com.zendesk.maxwell.monitoring.MaxwellMetrics;
import com.zendesk.maxwell.util.StoppableTask;
import io.prometheus.client.exporter.MetricsServlet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

class MaxwellHTTPServerWorker
implements StoppableTask,
Runnable {
    private final String bindAddress;
    private int port;
    private final String pathPrefix;
    private final MaxwellMetrics.Registries metricsRegistries;
    private final MaxwellDiagnosticContext diagnosticContext;
    private final MaxwellContext context;
    private Server server;

    public MaxwellHTTPServerWorker(String bindAddress, int port, String pathPrefix, MaxwellMetrics.Registries metricsRegistries, MaxwellDiagnosticContext diagnosticContext, MaxwellContext context) {
        this.bindAddress = bindAddress;
        this.port = port;
        this.pathPrefix = pathPrefix;
        this.metricsRegistries = metricsRegistries;
        this.diagnosticContext = diagnosticContext;
        this.context = context;
    }

    public void startServer() throws Exception {
        IndexListServlet indexList = new IndexListServlet();
        this.server = this.bindAddress != null ? new Server(new InetSocketAddress(InetAddress.getByName(this.bindAddress), this.port)) : new Server(this.port);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.server, this.pathPrefix);
        handler.addServlet(new ServletHolder((Servlet)indexList), "/");
        if (this.metricsRegistries != null) {
            handler.addServlet(new ServletHolder((Servlet)new com.codahale.metrics.servlets.MetricsServlet(this.metricsRegistries.metricRegistry)), "/metrics");
            handler.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/prometheus");
            handler.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(this.metricsRegistries.healthCheckRegistry)), "/healthcheck");
            handler.addServlet(new ServletHolder((Servlet)new PingServlet()), "/ping");
            indexList.addLink("/metrics", "codahale metrics");
            indexList.addLink("/prometheus", "prometheus metrics");
            indexList.addLink("/healthcheck", "healthcheck endpoint");
            indexList.addLink("/ping", "ping me");
        }
        if (this.context.getConfig().enableHttpConfig) {
            handler.addServlet(new ServletHolder((Servlet)new MaxwellConfigServlet(this.context)), "/config");
            indexList.addLink("/config", "POST endpoing to update maxwell config.");
        }
        if (this.diagnosticContext != null) {
            handler.addServlet(new ServletHolder((Servlet)new DiagnosticHealthCheck(this.diagnosticContext)), "/diagnostic");
            indexList.addLink("/diagnostic", "deeper diagnostic health checks");
        }
        this.server.start();
        this.server.join();
    }

    @Override
    public void run() {
        try {
            this.startServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void requestStop() throws Exception {
        this.server.stop();
    }

    @Override
    public void awaitStop(Long timeout) throws TimeoutException {
    }
}

