/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.MaxwellKafkaProducer;
import com.zendesk.maxwell.producer.MaxwellKafkaProducerWorker;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.row.RowIdentity;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaCallback
implements Callback {
    public static final Logger LOGGER = LoggerFactory.getLogger(MaxwellKafkaProducer.class);
    private final AbstractAsyncProducer.CallbackCompleter cc;
    private final Position position;
    private final String json;
    private final RowIdentity key;
    private final String topic;
    private final String fallbackTopic;
    private final MaxwellKafkaProducerWorker producer;
    private final MaxwellContext context;
    private Counter succeededMessageCount;
    private Counter failedMessageCount;
    private Meter succeededMessageMeter;
    private Meter failedMessageMeter;

    public KafkaCallback(AbstractAsyncProducer.CallbackCompleter cc, Position position, RowIdentity key, String json, Counter producedMessageCount, Counter failedMessageCount, Meter producedMessageMeter, Meter failedMessageMeter, String topic, String fallbackTopic, MaxwellContext context, MaxwellKafkaProducerWorker producer) {
        this.cc = cc;
        this.position = position;
        this.key = key;
        this.json = json;
        this.succeededMessageCount = producedMessageCount;
        this.failedMessageCount = failedMessageCount;
        this.succeededMessageMeter = producedMessageMeter;
        this.failedMessageMeter = failedMessageMeter;
        this.topic = topic;
        this.fallbackTopic = fallbackTopic;
        this.producer = producer;
        this.context = context;
    }

    public void onCompletion(RecordMetadata md, Exception e) {
        if (e != null) {
            boolean nonFatal;
            this.failedMessageCount.inc();
            this.failedMessageMeter.mark();
            LOGGER.error(e.getClass().getSimpleName() + " @ " + this.position + " -- " + this.topic + ": " + this.key);
            LOGGER.error(e.getLocalizedMessage());
            boolean bl = nonFatal = e instanceof RecordTooLargeException || this.context.getConfig().ignoreProducerError;
            if (nonFatal) {
                if (this.fallbackTopic == null) {
                    this.cc.markCompleted();
                } else {
                    this.publishFallback(md, e);
                }
            } else {
                this.context.terminate(e);
            }
        } else {
            this.succeededMessageCount.inc();
            this.succeededMessageMeter.mark();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("->  key:{}, partition:{}, offset:{}\n   {}\n   {}\n", new Object[]{this.key, md.partition(), md.offset(), this.json, this.position});
            }
            this.cc.markCompleted();
        }
    }

    private void publishFallback(RecordMetadata md, Exception e) {
        KafkaCallback cb = new KafkaCallback(this.cc, this.position, this.key, this.json, this.succeededMessageCount, this.failedMessageCount, this.succeededMessageMeter, this.failedMessageMeter, this.topic, null, this.context, this.producer);
        this.producer.enqueueFallbackRow(this.fallbackTopic, this.key, cb, md, e);
    }

    String getFallbackTopic() {
        return this.fallbackTopic;
    }
}

