/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSAsyncClientBuilder;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.SNSCallback;
import com.zendesk.maxwell.producer.partitioners.MaxwellSNSPartitioner;
import com.zendesk.maxwell.row.RowMap;
import java.util.HashMap;

public class MaxwellSNSProducer
extends AbstractAsyncProducer {
    private AmazonSNSAsync client;
    private String topic;
    private String[] stringFelds = new String[]{"database", "table"};
    private String[] numberFields = new String[]{"ts", "xid"};
    private MaxwellSNSPartitioner partitioner;

    public MaxwellSNSProducer(MaxwellContext context, String topic) {
        super(context);
        this.topic = topic;
        this.client = AmazonSNSAsyncClientBuilder.defaultClient();
        String partitionKey = context.getConfig().producerPartitionKey;
        String partitionColumns = context.getConfig().producerPartitionColumns;
        String partitionFallback = context.getConfig().producerPartitionFallback;
        this.partitioner = new MaxwellSNSPartitioner(partitionKey, partitionColumns, partitionFallback);
    }

    public void setClient(AmazonSNSAsync client) {
        this.client = client;
    }

    @Override
    public void sendAsync(RowMap r, AbstractAsyncProducer.CallbackCompleter cc) throws Exception {
        String value = r.toJSON(this.outputConfig);
        PublishRequest publishRequest = new PublishRequest(this.topic, value);
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        String configuredAttributes = this.context.getConfig().snsAttrs;
        if (configuredAttributes != null) {
            String[] stringArray = configuredAttributes.split(",");
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String element;
                switch (element = stringArray[i]) {
                    case "database": {
                        messageAttributes.put("database", new MessageAttributeValue().withDataType("String").withStringValue(r.getDatabase()));
                        continue block8;
                    }
                    case "table": {
                        messageAttributes.put("table", new MessageAttributeValue().withDataType("String").withStringValue(r.getTable()));
                    }
                }
            }
        }
        if (this.topic.endsWith(".fifo")) {
            String key = this.partitioner.getSNSKey(r);
            publishRequest.setMessageGroupId(key);
        }
        publishRequest.setMessageAttributes(messageAttributes);
        SNSCallback callback = new SNSCallback(cc, r.getNextPosition(), value, r.getDatabase(), r.getTable(), r.getRowIdentity().toConcatString(), r.getApproximateSize(), this.context);
        this.client.publishAsync(publishRequest, (AsyncHandler)callback);
    }
}

