/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.SchemaCapturer;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;
import com.zendesk.maxwell.schema.ddl.SchemaChange;
import com.zendesk.maxwell.util.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaStore {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchemaStore.class);
    protected final ConnectionPool replicationConnectionPool;
    protected final ConnectionPool schemaConnectionPool;
    protected final CaseSensitivity caseSensitivity;
    private final Filter filter;

    protected AbstractSchemaStore(ConnectionPool replicationConnectionPool, ConnectionPool schemaConnectionPool, CaseSensitivity caseSensitivity, Filter filter) {
        this.replicationConnectionPool = replicationConnectionPool;
        this.schemaConnectionPool = schemaConnectionPool;
        this.caseSensitivity = caseSensitivity;
        this.filter = filter;
    }

    protected AbstractSchemaStore(MaxwellContext context) throws SQLException {
        this(context.getReplicationConnectionPool(), context.getSchemaConnectionPool(), context.getCaseSensitivity(), context.getFilter());
    }

    protected Schema captureSchema() throws SQLException {
        LOGGER.info("Maxwell is capturing initial schema");
        try (Connection connection = this.schemaConnectionPool.getConnection();){
            Schema schema;
            try (SchemaCapturer capturer = new SchemaCapturer(connection, this.caseSensitivity);){
                schema = capturer.capture();
            }
            return schema;
        }
    }

    protected List<ResolvedSchemaChange> resolveSQL(Schema schema, String sql, String currentDatabase) throws InvalidSchemaError {
        List<SchemaChange> changes = SchemaChange.parse(currentDatabase, sql);
        if (changes == null || changes.size() == 0) {
            return new ArrayList<ResolvedSchemaChange>();
        }
        ArrayList<ResolvedSchemaChange> resolvedSchemaChanges = new ArrayList<ResolvedSchemaChange>();
        for (SchemaChange change : changes) {
            if (!change.isBlacklisted(this.filter)) {
                ResolvedSchemaChange resolved = change.resolve(schema);
                if (resolved == null) continue;
                resolved.apply(schema);
                resolvedSchemaChanges.add(resolved);
                continue;
            }
            LOGGER.debug("ignoring blacklisted schema change");
        }
        return resolvedSchemaChanges;
    }
}

