/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.errors.DuplicateProcessException;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.schema.MysqlPositionStore;
import com.zendesk.maxwell.util.RunLoopProcess;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionStoreThread
extends RunLoopProcess
implements Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(PositionStoreThread.class);
    private Position position;
    private Position storedPosition;
    private final MysqlPositionStore store;
    private MaxwellContext context;
    private Exception exception;
    private Thread thread;
    private BinlogPosition lastHeartbeatSentFrom;
    private long lastHeartbeatSent;

    public PositionStoreThread(MysqlPositionStore store, MaxwellContext context) {
        this.store = store;
        this.context = context;
        this.lastHeartbeatSentFrom = null;
        this.lastHeartbeatSent = 0L;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "Position Flush Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            this.runLoop();
        }
        catch (Exception e) {
            this.exception = e;
            this.context.terminate(e);
        }
        finally {
            this.taskState.stopped();
        }
    }

    @Override
    protected void beforeStop() {
        if (this.exception == null) {
            try {
                this.storeFinalPosition();
            }
            catch (Exception e) {
                LOGGER.error("error storing final position: " + e);
            }
        }
    }

    void storeFinalPosition() throws SQLException, DuplicateProcessException {
        if (this.position != null && !this.position.equals(this.storedPosition)) {
            LOGGER.info("Storing final position: " + this.position);
            this.store.set(this.position);
        }
    }

    public void heartbeat() throws Exception {
        this.store.heartbeat();
    }

    boolean shouldHeartbeat(Position currentPosition) {
        if (currentPosition == null) {
            return true;
        }
        if (this.lastHeartbeatSentFrom == null) {
            return true;
        }
        BinlogPosition currentBinlog = currentPosition.getBinlogPosition();
        if (!this.lastHeartbeatSentFrom.getFile().equals(currentBinlog.getFile())) {
            return true;
        }
        if (currentBinlog.getOffset() - this.lastHeartbeatSentFrom.getOffset() > 3000L) {
            return true;
        }
        long secondsSinceHeartbeat = (System.currentTimeMillis() - this.lastHeartbeatSent) / 1000L;
        return secondsSinceHeartbeat >= 10L;
    }

    @Override
    public void work() throws Exception {
        Position newPosition = this.position;
        if (newPosition != null && newPosition.newerThan(this.storedPosition)) {
            this.store.set(newPosition);
            this.storedPosition = newPosition;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.shouldHeartbeat(newPosition)) {
            this.lastHeartbeatSent = this.store.heartbeat();
            if (newPosition != null) {
                this.lastHeartbeatSentFrom = newPosition.getBinlogPosition();
            }
        }
    }

    public synchronized void setPosition(Position p) {
        if (this.context.isMariaDB() && this.position != null) {
            BinlogPosition bp = p.getBinlogPosition();
            if (bp.getGtid() != null) {
                bp.mergeGtids(this.position.getBinlogPosition().getGtidSet());
            }
            this.position = p;
        } else if (this.position == null || p.newerThan(this.position)) {
            this.position = p;
            if (this.storedPosition == null) {
                this.storedPosition = p;
            }
        }
    }

    public synchronized Position getPosition() throws SQLException {
        if (this.position != null) {
            return this.position;
        }
        this.position = this.store.get();
        return this.position;
    }
}

