/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TableColumnList
implements Iterable<ColumnDef> {
    private ImmutableColumnList columnList;

    public TableColumnList(List<ColumnDef> columns) {
        this.columnList = ImmutableColumnList.create(columns);
    }

    @Override
    public Iterator<ColumnDef> iterator() {
        return this.columnList.getColumns().iterator();
    }

    public List<ColumnDef> getList() {
        return this.columnList.getColumns();
    }

    public synchronized Set<String> columnNames() {
        return this.columnList.getColumnNames();
    }

    public synchronized int indexOf(String name) {
        return this.indexOf(this.columnList.getColumns(), name);
    }

    private synchronized int indexOf(List<ColumnDef> columns, String name) {
        String lcName = name.toLowerCase();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).getName().toLowerCase().equals(lcName)) continue;
            return i;
        }
        return -1;
    }

    public ColumnDef findByName(String name) {
        List<ColumnDef> columns = this.columnList.getColumns();
        int index = this.indexOf(columns, name);
        if (index == -1) {
            return null;
        }
        return columns.get(index);
    }

    public synchronized void add(int index, ColumnDef definition) {
        List<ColumnDef> columns = this.columnList.getColumns();
        ArrayList<ColumnDef> tempList = new ArrayList<ColumnDef>(columns.size() + 1);
        tempList.addAll(columns);
        tempList.add(index, definition);
        this.columnList = ImmutableColumnList.create(tempList);
    }

    public synchronized void addAll(List<ColumnDef> columnDefs) {
        this.columnList = ImmutableColumnList.create(columnDefs);
    }

    public synchronized void replace(int index, ColumnDef definition) {
        List<ColumnDef> columns = this.columnList.getColumns();
        ArrayList<ColumnDef> tempList = new ArrayList<ColumnDef>(columns.size());
        tempList.addAll(columns);
        tempList.set(index, definition);
        this.columnList = ImmutableColumnList.create(tempList);
    }

    public synchronized ColumnDef remove(int index) {
        List<ColumnDef> columns = this.columnList.getColumns();
        ArrayList<ColumnDef> tempList = new ArrayList<ColumnDef>(columns.size());
        tempList.addAll(columns);
        ColumnDef c = (ColumnDef)tempList.remove(index);
        this.columnList = ImmutableColumnList.create(tempList);
        return c;
    }

    public synchronized ColumnDef get(int index) {
        return this.columnList.getColumns().get(index);
    }

    public int size() {
        return this.columnList.getColumns().size();
    }

    private static final class ImmutableColumnList {
        private static final Interner<ImmutableColumnList> INTERNER = Interners.newWeakInterner();
        private final List<ColumnDef> columns;
        private Set<String> columnNames;

        private ImmutableColumnList(List<ColumnDef> columns) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columns.size());
            int i = 0;
            for (ColumnDef column : columns) {
                builder.add((Object)column.withPos((short)i++));
            }
            this.columns = builder.build();
        }

        public static ImmutableColumnList create(List<ColumnDef> columns) {
            return (ImmutableColumnList)INTERNER.intern((Object)new ImmutableColumnList(columns));
        }

        public boolean equals(Object o) {
            if (o instanceof ImmutableColumnList) {
                ImmutableColumnList other = (ImmutableColumnList)o;
                return this.columns.equals(other.columns);
            }
            return false;
        }

        public int hashCode() {
            return this.columns.hashCode();
        }

        public List<ColumnDef> getColumns() {
            return this.columns;
        }

        public Set<String> getColumnNames() {
            if (this.columnNames == null) {
                this.columnNames = this.generateColumnNames();
            }
            return this.columnNames;
        }

        private Set<String> generateColumnNames() {
            ImmutableSet.Builder setBuilder = ImmutableSet.builderWithExpectedSize((int)this.columns.size());
            for (ColumnDef cf : this.columns) {
                setBuilder.add((Object)cf.getName().toLowerCase().intern());
            }
            return setBuilder.build();
        }
    }
}

