/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import java.util.Objects;

public class IntColumnDef
extends ColumnDef {
    private final int bits;
    private boolean signed;

    private IntColumnDef(String name, String type, short pos, boolean signed) {
        super(name, type, pos);
        this.signed = signed;
        this.bits = IntColumnDef.bitsFromType(type);
    }

    public static IntColumnDef create(String name, String type, short pos, boolean signed) {
        IntColumnDef temp = new IntColumnDef(name, type, pos, signed);
        return (IntColumnDef)INTERNER.intern((Object)temp);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            IntColumnDef other = (IntColumnDef)o;
            return super.equals(o) && this.bits == other.bits && this.signed == other.signed;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Objects.hash(this.bits, this.signed);
    }

    private long castUnsigned(Integer i, long max_value) {
        if (i < 0) {
            return max_value + (long)i.intValue();
        }
        return i.intValue();
    }

    private Long toLong(Object value) throws ColumnDefCastException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (this.signed) {
                return (long)i;
            }
            long res = this.castUnsigned(i, 1L << this.bits);
            return res;
        }
        throw new ColumnDefCastException(this, value);
    }

    @Override
    public String toSQL(Object value) throws ColumnDefCastException {
        return this.toLong(value).toString();
    }

    @Override
    public Object asJSON(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        return this.toLong(value);
    }

    private static final int bitsFromType(String type) {
        switch (type) {
            case "tinyint": {
                return 8;
            }
            case "smallint": {
                return 16;
            }
            case "mediumint": {
                return 24;
            }
            case "int": {
                return 32;
            }
        }
        return 0;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public IntColumnDef withSigned(boolean signed) {
        return this.cloneSelfAndSet(clone -> {
            clone.signed = signed;
        });
    }
}

