/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;

public class ResolvedTableCreate
extends ResolvedSchemaChange {
    public String database;
    public String table;
    public Table def;

    public ResolvedTableCreate() {
    }

    public ResolvedTableCreate(Table t) {
        this.database = t.database;
        this.table = t.name;
        this.def = t;
    }

    @Override
    public void apply(Schema schema) throws InvalidSchemaError {
        Database d = schema.findDatabaseOrThrow(this.database);
        if (d.hasTable(this.table)) {
            throw new InvalidSchemaError("Unexpectedly asked to create existing table " + this.table);
        }
        d.addTable(this.def);
    }

    @Override
    public String databaseName() {
        return this.database;
    }

    @Override
    public String tableName() {
        return this.table;
    }
}

