/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.scripting;

import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.row.RowMap;
import java.util.LinkedHashMap;

public class WrappedRowMap {
    private final RowMap row;

    public WrappedRowMap(RowMap row) {
        this.row = row;
    }

    public LinkedHashMap<String, Object> getData() {
        return this.row.getData();
    }

    public LinkedHashMap<String, Object> getOld_data() {
        return this.row.getOldData();
    }

    public LinkedHashMap<String, Object> getExtra_attributes() {
        return this.row.getExtraAttributes();
    }

    public String getType() {
        return this.row.getRowType();
    }

    public String getTable() {
        return this.row.getTable();
    }

    public String getDatabase() {
        return this.row.getDatabase();
    }

    public String getPosition() {
        Position pp = this.row.getPosition();
        if (pp == null) {
            return null;
        }
        BinlogPosition p = pp.getBinlogPosition();
        if (p == null) {
            return null;
        }
        if (p.getGtid() != null) {
            return p.getGtid();
        }
        return p.getFile() + ":" + p.getOffset();
    }

    public Long getXid() {
        return this.row.getXid();
    }

    public Long getServer_id() {
        return this.row.getServerId();
    }

    public Long getThread_id() {
        return this.row.getThreadId();
    }

    public Long getTimestamp() {
        return this.row.getTimestamp();
    }

    public String getQuery() {
        return this.row.getRowQuery();
    }

    public void setQuery(String query) {
        this.row.setRowQuery(query);
    }

    public void suppress() {
        this.row.suppress();
    }

    public void setKafka_topic(String topic) {
        this.row.setKafkaTopic(topic);
    }

    public void setPartition_string(String partitionString) {
        this.row.setPartitionString(partitionString);
    }
}

