/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import com.zendesk.maxwell.util.MaxwellHelpFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import joptsimple.HelpFormatter;
import joptsimple.OptionParser;
import joptsimple.OptionSpecBuilder;

public class MaxwellOptionParser
extends OptionParser {
    private String currentSection = null;
    private ArrayList<String> sectionNames = new ArrayList();
    private HashMap<String, ArrayList<String>> sections = new HashMap();
    private MaxwellHelpFormatter helpFormatter = new MaxwellHelpFormatter(200, 4, this.sections, this.sectionNames);
    private int separatorIndex = 0;

    public MaxwellOptionParser() {
        this.formatHelpWith((HelpFormatter)this.helpFormatter);
    }

    public void addToSection(String optionName) {
        ArrayList list = this.sections.computeIfAbsent(this.currentSection, k -> new ArrayList());
        list.add(optionName);
    }

    public OptionSpecBuilder accepts(String option, String description) {
        this.addToSection(option);
        return super.accepts(option, description);
    }

    public void separator() {
        this.accepts("__separator_" + ++this.separatorIndex, "");
    }

    public void section(String section) {
        this.accepts("__section_" + section);
        this.currentSection = section;
        this.sectionNames.add(section);
    }

    public void printHelpOn(PrintStream err, String section) throws IOException {
        this.helpFormatter.setSection(section);
        super.printHelpOn((OutputStream)err);
    }
}

