/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import com.zendesk.maxwell.util.RunState;
import com.zendesk.maxwell.util.StoppableTask;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManager.class);
    private final ArrayList<StoppableTask> tasks = new ArrayList();
    private volatile RunState state = RunState.RUNNING;

    public synchronized boolean requestStop() {
        if (this.state == RunState.RUNNING) {
            this.state = RunState.REQUEST_STOP;
            return true;
        }
        return false;
    }

    public synchronized void stop(Exception error) throws Exception {
        if (this.state == RunState.STOPPED) {
            LOGGER.debug("Stop() called multiple times");
            return;
        }
        this.state = RunState.REQUEST_STOP;
        LOGGER.info("Stopping " + this.tasks.size() + " tasks");
        if (error != null) {
            LOGGER.error("cause: ", (Throwable)error);
        }
        for (StoppableTask task : this.tasks) {
            LOGGER.info("Stopping: " + task);
            task.requestStop();
        }
        Long timeout = 1000L;
        for (StoppableTask task : this.tasks) {
            LOGGER.debug("Awaiting stop of: {}", (Object)task);
            task.awaitStop(timeout);
        }
        this.state = RunState.STOPPED;
        LOGGER.info("Stopped all tasks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(StoppableTask task) {
        ArrayList<StoppableTask> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(task);
        }
    }
}

