/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or;

import com.google.code.or.binlog.BinlogEventListener;
import com.google.code.or.binlog.BinlogParser;
import com.google.code.or.binlog.impl.FileBasedBinlogParser;
import com.google.code.or.binlog.impl.parser.DeleteRowsEventParser;
import com.google.code.or.binlog.impl.parser.DeleteRowsEventV2Parser;
import com.google.code.or.binlog.impl.parser.FormatDescriptionEventParser;
import com.google.code.or.binlog.impl.parser.IncidentEventParser;
import com.google.code.or.binlog.impl.parser.IntvarEventParser;
import com.google.code.or.binlog.impl.parser.QueryEventParser;
import com.google.code.or.binlog.impl.parser.RandEventParser;
import com.google.code.or.binlog.impl.parser.RotateEventParser;
import com.google.code.or.binlog.impl.parser.StopEventParser;
import com.google.code.or.binlog.impl.parser.TableMapEventParser;
import com.google.code.or.binlog.impl.parser.UpdateRowsEventParser;
import com.google.code.or.binlog.impl.parser.UpdateRowsEventV2Parser;
import com.google.code.or.binlog.impl.parser.UserVarEventParser;
import com.google.code.or.binlog.impl.parser.WriteRowsEventParser;
import com.google.code.or.binlog.impl.parser.WriteRowsEventV2Parser;
import com.google.code.or.binlog.impl.parser.XidEventParser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class OpenParser {
    protected long stopPosition;
    protected long startPosition;
    protected String binlogFileName;
    protected String binlogFilePath;
    protected BinlogParser binlogParser;
    protected BinlogEventListener binlogEventListener;
    protected final AtomicBoolean running = new AtomicBoolean(false);

    public boolean isRunning() {
        return this.running.get();
    }

    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (this.binlogParser == null) {
            this.binlogParser = this.getDefaultBinlogParser();
        }
        this.binlogParser.setEventListener(this.binlogEventListener);
        this.binlogParser.start();
    }

    public void stop(long timeout, TimeUnit unit) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.binlogParser.stop(timeout, unit);
    }

    public long getStopPosition() {
        return this.stopPosition;
    }

    public void setStopPosition(long position) {
        this.stopPosition = position;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long position) {
        this.startPosition = position;
    }

    public String getBinlogFileName() {
        return this.binlogFileName;
    }

    public void setBinlogFileName(String name) {
        this.binlogFileName = name;
    }

    public String getBinlogFilePath() {
        return this.binlogFilePath;
    }

    public void setBinlogFilePath(String path) {
        this.binlogFilePath = path;
    }

    public BinlogParser getBinlogParser() {
        return this.binlogParser;
    }

    public void setBinlogParser(BinlogParser parser) {
        this.binlogParser = parser;
    }

    public BinlogEventListener getBinlogEventListener() {
        return this.binlogEventListener;
    }

    public void setBinlogEventListener(BinlogEventListener listener) {
        this.binlogEventListener = listener;
    }

    protected FileBasedBinlogParser getDefaultBinlogParser() throws Exception {
        FileBasedBinlogParser r = new FileBasedBinlogParser();
        r.registerEventParser(new StopEventParser());
        r.registerEventParser(new RotateEventParser());
        r.registerEventParser(new IntvarEventParser());
        r.registerEventParser(new XidEventParser());
        r.registerEventParser(new RandEventParser());
        r.registerEventParser(new QueryEventParser());
        r.registerEventParser(new UserVarEventParser());
        r.registerEventParser(new IncidentEventParser());
        r.registerEventParser(new TableMapEventParser());
        r.registerEventParser(new WriteRowsEventParser());
        r.registerEventParser(new UpdateRowsEventParser());
        r.registerEventParser(new DeleteRowsEventParser());
        r.registerEventParser(new WriteRowsEventV2Parser());
        r.registerEventParser(new UpdateRowsEventV2Parser());
        r.registerEventParser(new DeleteRowsEventV2Parser());
        r.registerEventParser(new FormatDescriptionEventParser());
        r.setStopPosition(this.stopPosition);
        r.setStartPosition(this.startPosition);
        r.setBinlogFileName(this.binlogFileName);
        r.setBinlogFilePath(this.binlogFilePath);
        return r;
    }
}

