/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or;

import com.google.code.or.binlog.BinlogEventListener;
import com.google.code.or.binlog.BinlogParser;
import com.google.code.or.binlog.BinlogParserListener;
import com.google.code.or.binlog.impl.ReplicationBasedBinlogParser;
import com.google.code.or.binlog.impl.parser.DeleteRowsEventParser;
import com.google.code.or.binlog.impl.parser.DeleteRowsEventV2Parser;
import com.google.code.or.binlog.impl.parser.FormatDescriptionEventParser;
import com.google.code.or.binlog.impl.parser.IncidentEventParser;
import com.google.code.or.binlog.impl.parser.IntvarEventParser;
import com.google.code.or.binlog.impl.parser.QueryEventParser;
import com.google.code.or.binlog.impl.parser.RandEventParser;
import com.google.code.or.binlog.impl.parser.RotateEventParser;
import com.google.code.or.binlog.impl.parser.StopEventParser;
import com.google.code.or.binlog.impl.parser.TableMapEventParser;
import com.google.code.or.binlog.impl.parser.UpdateRowsEventParser;
import com.google.code.or.binlog.impl.parser.UpdateRowsEventV2Parser;
import com.google.code.or.binlog.impl.parser.UserVarEventParser;
import com.google.code.or.binlog.impl.parser.WriteRowsEventParser;
import com.google.code.or.binlog.impl.parser.WriteRowsEventV2Parser;
import com.google.code.or.binlog.impl.parser.XidEventParser;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.io.impl.SocketFactoryImpl;
import com.google.code.or.net.Packet;
import com.google.code.or.net.Transport;
import com.google.code.or.net.TransportException;
import com.google.code.or.net.impl.AuthenticatorImpl;
import com.google.code.or.net.impl.Query;
import com.google.code.or.net.impl.TransportImpl;
import com.google.code.or.net.impl.packet.ErrorPacket;
import com.google.code.or.net.impl.packet.command.ComBinlogDumpPacket;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenReplicator {
    protected int port = 3306;
    protected String host;
    protected String user;
    protected String password;
    protected int serverId = 6789;
    protected String binlogFileName;
    protected long binlogPosition = 4L;
    protected String encoding = "utf-8";
    protected int level1BufferSize = 0x100000;
    protected int level2BufferSize = 0x800000;
    protected int socketReceiveBufferSize = 524288;
    protected Transport transport;
    protected ReplicationBasedBinlogParser binlogParser;
    protected BinlogEventListener binlogEventListener;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenReplicator.class);

    public boolean isRunning() {
        return this.running.get();
    }

    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (this.transport == null) {
            this.transport = this.getDefaultTransport();
        }
        this.transport.connect(this.host, this.port);
        if (this.binlogParser == null) {
            this.binlogParser = this.getDefaultBinlogParser();
        }
        this.setupChecksumState();
        this.dumpBinlog();
        this.binlogParser.setBinlogFileName(this.binlogFileName);
        this.binlogParser.setEventListener(this.binlogEventListener);
        this.binlogParser.addParserListener(new BinlogParserListener.Adapter(){

            public void onStop(BinlogParser parser) {
                OpenReplicator.this.stopQuietly(0L, TimeUnit.MILLISECONDS);
            }
        });
        this.binlogParser.start();
    }

    public void stop(long timeout, TimeUnit unit) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.transport.disconnect();
        this.binlogParser.stop(timeout, unit);
    }

    public void stopQuietly(long timeout, TimeUnit unit) {
        try {
            this.stop(timeout, unit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public long getBinlogPosition() {
        return this.binlogPosition;
    }

    public void setBinlogPosition(long binlogPosition) {
        this.binlogPosition = binlogPosition;
    }

    public String getBinlogFileName() {
        return this.binlogFileName;
    }

    public void setBinlogFileName(String binlogFileName) {
        this.binlogFileName = binlogFileName;
    }

    public int getLevel1BufferSize() {
        return this.level1BufferSize;
    }

    public void setLevel1BufferSize(int level1BufferSize) {
        this.level1BufferSize = level1BufferSize;
    }

    public int getLevel2BufferSize() {
        return this.level2BufferSize;
    }

    public void setLevel2BufferSize(int level2BufferSize) {
        this.level2BufferSize = level2BufferSize;
    }

    public int getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    public void setSocketReceiveBufferSize(int socketReceiveBufferSize) {
        this.socketReceiveBufferSize = socketReceiveBufferSize;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public BinlogParser getBinlogParser() {
        return this.binlogParser;
    }

    public void setBinlogParser(ReplicationBasedBinlogParser parser) {
        this.binlogParser = parser;
    }

    public BinlogEventListener getBinlogEventListener() {
        return this.binlogEventListener;
    }

    public void setBinlogEventListener(BinlogEventListener listener) {
        this.binlogEventListener = listener;
    }

    protected void setupChecksumState() throws Exception {
        block3: {
            Query query = new Query(this.transport);
            try {
                List<String> cols = query.getFirst("SELECT @@global.binlog_checksum");
                if (cols != null && cols.get(0).equals("CRC32") || cols.get(0).equals("NONE")) {
                    query.getFirst("SET @master_binlog_checksum = @@global.binlog_checksum");
                }
            }
            catch (TransportException e) {
                if (e.getErrorCode() == 1193) break block3;
                throw e;
            }
        }
    }

    protected void dumpBinlog() throws Exception {
        ComBinlogDumpPacket command = new ComBinlogDumpPacket();
        command.setBinlogFlag(0);
        command.setServerId(this.serverId);
        command.setBinlogPosition(this.binlogPosition);
        command.setBinlogFileName(StringColumn.valueOf(this.binlogFileName.getBytes(this.encoding)));
        this.transport.getOutputStream().writePacket(command);
        this.transport.getOutputStream().flush();
        Packet packet = this.transport.getInputStream().readPacket();
        if (packet.getPacketBody()[0] == -1) {
            ErrorPacket error = ErrorPacket.valueOf(packet);
            throw new TransportException(error);
        }
    }

    protected Transport getDefaultTransport() throws Exception {
        TransportImpl r = new TransportImpl();
        r.setLevel1BufferSize(this.level1BufferSize);
        r.setLevel2BufferSize(this.level2BufferSize);
        AuthenticatorImpl authenticator = new AuthenticatorImpl();
        authenticator.setUser(this.user);
        authenticator.setPassword(this.password);
        authenticator.setEncoding(this.encoding);
        r.setAuthenticator(authenticator);
        SocketFactoryImpl socketFactory = new SocketFactoryImpl();
        socketFactory.setKeepAlive(true);
        socketFactory.setTcpNoDelay(false);
        socketFactory.setReceiveBufferSize(this.socketReceiveBufferSize);
        r.setSocketFactory(socketFactory);
        return r;
    }

    protected ReplicationBasedBinlogParser getDefaultBinlogParser() throws Exception {
        ReplicationBasedBinlogParser r = new ReplicationBasedBinlogParser();
        r.registerEventParser(new StopEventParser());
        r.registerEventParser(new RotateEventParser());
        r.registerEventParser(new IntvarEventParser());
        r.registerEventParser(new XidEventParser());
        r.registerEventParser(new RandEventParser());
        r.registerEventParser(new QueryEventParser());
        r.registerEventParser(new UserVarEventParser());
        r.registerEventParser(new IncidentEventParser());
        r.registerEventParser(new TableMapEventParser());
        r.registerEventParser(new WriteRowsEventParser());
        r.registerEventParser(new UpdateRowsEventParser());
        r.registerEventParser(new DeleteRowsEventParser());
        r.registerEventParser(new WriteRowsEventV2Parser());
        r.registerEventParser(new UpdateRowsEventV2Parser());
        r.registerEventParser(new DeleteRowsEventV2Parser());
        r.registerEventParser(new FormatDescriptionEventParser());
        r.setTransport(this.transport);
        return r;
    }
}

