/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl;

import com.google.code.or.binlog.BinlogEventParser;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.AbstractBinlogParser;
import com.google.code.or.binlog.impl.event.BinlogEventV4HeaderImpl;
import com.google.code.or.binlog.impl.parser.FormatDescriptionEventParser;
import com.google.code.or.common.util.CodecUtils;
import com.google.code.or.common.util.IOUtils;
import com.google.code.or.common.util.MySQLConstants;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.impl.XInputStreamImpl;
import com.google.code.or.io.util.RamdomAccessFileInputStream;
import com.google.code.or.net.impl.EventInputStream;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedBinlogParser
extends AbstractBinlogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedBinlogParser.class);
    protected XInputStream is;
    protected String binlogFileName;
    protected String binlogFilePath;
    protected long stopPosition = 0L;
    protected long startPosition = 4L;

    protected void doStart() throws Exception {
        this.is = this.open(this.binlogFilePath + "/" + this.binlogFileName, this.startPosition);
    }

    protected void doStop(long timeout, TimeUnit unit) throws Exception {
        IOUtils.closeQuietly(this.is);
    }

    public String getBinlogFileName() {
        return this.binlogFileName;
    }

    public void setBinlogFileName(String name) {
        this.binlogFileName = name;
    }

    public String getBinlogFilePath() {
        return this.binlogFilePath;
    }

    public void setBinlogFilePath(String path) {
        this.binlogFilePath = path;
    }

    public long getStopPosition() {
        return this.stopPosition;
    }

    public void setStopPosition(long stopPosition) {
        this.stopPosition = stopPosition;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    protected void doParse() throws Exception {
        AbstractBinlogParser.Context context = new AbstractBinlogParser.Context(this);
        EventInputStream es = new EventInputStream(this.is);
        es.setChecksumEnabled(this.findChecksumEnabled());
        while (this.isRunning() && this.is.available() > 0) {
            BinlogEventV4HeaderImpl header = es.getNextBinlogHeader();
            try {
                if (this.isVerbose() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("read an event, header: {}", (Object)header);
                }
                if (this.stopPosition > 0L && header.getPosition() > this.stopPosition) break;
                if (this.eventFilter != null && !this.eventFilter.accepts(header, context)) {
                    this.defaultParser.parse(es, header, context);
                } else {
                    BinlogEventParser parser = this.getEventParser(header.getEventType());
                    if (parser == null) {
                        parser = this.defaultParser;
                    }
                    parser.parse(es, header, context);
                }
                es.finishEvent(header);
            }
            catch (Exception e) {
                IOUtils.closeQuietly(this.is);
                throw e;
            }
            finally {
                this.is.setReadLimit(0);
            }
        }
    }

    private boolean findChecksumEnabled() throws Exception {
        XInputStream is = this.open(this.binlogFilePath + "/" + this.binlogFileName, 4L);
        AbstractBinlogParser.Context context = new AbstractBinlogParser.Context((AbstractBinlogParser)this){

            public void onEvents(BinlogEventV4 event) {
            }
        };
        EventInputStream es = new EventInputStream(is);
        BinlogEventV4HeaderImpl header = es.getNextBinlogHeader();
        if (header.getEventType() != 15) {
            throw new RuntimeException("Expected FORMAT_DESCRIPTION_EVENT at top of file, found " + header);
        }
        new FormatDescriptionEventParser().parse(es, header, context);
        es.finishEvent(header);
        es.close();
        return context.getChecksumEnabled();
    }

    protected XInputStream open(String path, Long offset) throws Exception {
        XInputStreamImpl is = new XInputStreamImpl(new RamdomAccessFileInputStream(new File(path)));
        try {
            byte[] magic = is.readBytes(MySQLConstants.BINLOG_MAGIC.length);
            if (!CodecUtils.equals(magic, MySQLConstants.BINLOG_MAGIC)) {
                throw new RuntimeException("invalid binlog magic, file: " + path);
            }
            if (offset > (long)MySQLConstants.BINLOG_MAGIC.length) {
                is.skip(offset - (long)MySQLConstants.BINLOG_MAGIC.length);
            }
            return is;
        }
        catch (Exception e) {
            IOUtils.closeQuietly(is);
            throw e;
        }
    }
}

