/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.parser;

import com.google.code.or.binlog.BinlogRowEventFilter;
import com.google.code.or.binlog.impl.event.TableMapEvent;
import com.google.code.or.binlog.impl.filter.BinlogRowEventFilterImpl;
import com.google.code.or.binlog.impl.parser.AbstractBinlogEventParser;
import com.google.code.or.common.glossary.Column;
import com.google.code.or.common.glossary.Metadata;
import com.google.code.or.common.glossary.Row;
import com.google.code.or.common.glossary.column.BitColumn;
import com.google.code.or.common.glossary.column.BlobColumn;
import com.google.code.or.common.glossary.column.DateColumn;
import com.google.code.or.common.glossary.column.Datetime2Column;
import com.google.code.or.common.glossary.column.DatetimeColumn;
import com.google.code.or.common.glossary.column.DecimalColumn;
import com.google.code.or.common.glossary.column.DoubleColumn;
import com.google.code.or.common.glossary.column.EnumColumn;
import com.google.code.or.common.glossary.column.FloatColumn;
import com.google.code.or.common.glossary.column.GeometryColumn;
import com.google.code.or.common.glossary.column.Int24Column;
import com.google.code.or.common.glossary.column.LongColumn;
import com.google.code.or.common.glossary.column.LongLongColumn;
import com.google.code.or.common.glossary.column.NullColumn;
import com.google.code.or.common.glossary.column.SetColumn;
import com.google.code.or.common.glossary.column.ShortColumn;
import com.google.code.or.common.glossary.column.Time2Column;
import com.google.code.or.common.glossary.column.TimeColumn;
import com.google.code.or.common.glossary.column.Timestamp2Column;
import com.google.code.or.common.glossary.column.TimestampColumn;
import com.google.code.or.common.glossary.column.TinyColumn;
import com.google.code.or.common.glossary.column.YearColumn;
import com.google.code.or.common.util.CodecUtils;
import com.google.code.or.common.util.MySQLUtils;
import com.google.code.or.io.XInputStream;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowEventParser
extends AbstractBinlogEventParser {
    protected BinlogRowEventFilter rowEventFilter = new BinlogRowEventFilterImpl();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRowEventParser.class);

    public AbstractRowEventParser(int eventType) {
        super(eventType);
    }

    public BinlogRowEventFilter getRowEventFilter() {
        return this.rowEventFilter;
    }

    public void setRowEventFilter(BinlogRowEventFilter filter) {
        this.rowEventFilter = filter;
    }

    protected Row parseRow(XInputStream is, TableMapEvent tme, BitColumn usedColumns) throws IOException {
        int unusedColumnCount = 0;
        byte[] types = tme.getColumnTypes();
        Metadata metadata = tme.getColumnMetadata();
        int nColumnsUsed = usedColumns.getSetBitCount();
        BitColumn nullColumns = is.readBit(nColumnsUsed);
        ArrayList<Column> columns = new ArrayList<Column>(nColumnsUsed);
        block30: for (int i = 0; i < types.length; ++i) {
            int length = 0;
            int meta = metadata.getMetadata(i);
            int type = CodecUtils.toUnsigned(types[i]);
            if (type == 254 && meta > 256) {
                int meta0 = meta >> 8;
                int meta1 = meta & 0xFF;
                if ((meta0 & 0x30) != 48) {
                    type = meta0 | 0x30;
                    length = meta1 | (meta0 & 0x30 ^ 0x30) << 4;
                } else {
                    switch (meta0) {
                        case 247: 
                        case 248: 
                        case 254: {
                            type = meta0;
                            length = meta1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("assertion failed, unknown column type: " + type);
                        }
                    }
                }
            }
            if (!usedColumns.get(i)) {
                ++unusedColumnCount;
                continue;
            }
            if (nullColumns.get(i - unusedColumnCount)) {
                columns.add(NullColumn.valueOf(type));
                continue;
            }
            switch (type) {
                case 1: {
                    columns.add(TinyColumn.valueOf(is.readSignedInt(1)));
                    continue block30;
                }
                case 2: {
                    columns.add(ShortColumn.valueOf(is.readSignedInt(2)));
                    continue block30;
                }
                case 9: {
                    columns.add(Int24Column.valueOf(is.readSignedInt(3)));
                    continue block30;
                }
                case 3: {
                    columns.add(LongColumn.valueOf(is.readSignedInt(4)));
                    continue block30;
                }
                case 8: {
                    columns.add(LongLongColumn.valueOf(is.readSignedLong(8)));
                    continue block30;
                }
                case 4: {
                    columns.add(FloatColumn.valueOf(Float.intBitsToFloat(is.readInt(4))));
                    continue block30;
                }
                case 5: {
                    columns.add(DoubleColumn.valueOf(Double.longBitsToDouble(is.readLong(8))));
                    continue block30;
                }
                case 13: {
                    columns.add(YearColumn.valueOf(MySQLUtils.toYear(is.readInt(1))));
                    continue block30;
                }
                case 10: {
                    columns.add(DateColumn.valueOf(MySQLUtils.toDate(is.readInt(3))));
                    continue block30;
                }
                case 11: {
                    columns.add(TimeColumn.valueOf(MySQLUtils.toTime(is.readInt(3))));
                    continue block30;
                }
                case 12: {
                    columns.add(DatetimeColumn.valueOf(is.readLong(8)));
                    continue block30;
                }
                case 7: {
                    columns.add(TimestampColumn.valueOf(MySQLUtils.toTimestamp(is.readLong(4))));
                    continue block30;
                }
                case 247: {
                    columns.add(EnumColumn.valueOf(is.readInt(length)));
                    continue block30;
                }
                case 248: {
                    columns.add(SetColumn.valueOf(is.readLong(length)));
                    continue block30;
                }
                case 16: {
                    int bitLength = (meta >> 8) * 8 + (meta & 0xFF);
                    columns.add(is.readBit(bitLength, false));
                    continue block30;
                }
                case 252: {
                    int blobLength = is.readInt(meta);
                    columns.add(BlobColumn.valueOf(is.readBytes(blobLength)));
                    continue block30;
                }
                case 255: {
                    int geomLength = is.readInt(meta);
                    int _unknown = is.readInt(4);
                    WKBReader reader = new WKBReader();
                    try {
                        Geometry g = reader.read(is.readBytes(geomLength - 4));
                        columns.add(GeometryColumn.valueOf(g));
                        continue block30;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Could not parse geometry, unknown column was " + _unknown, e);
                    }
                }
                case 246: {
                    int precision = meta & 0xFF;
                    int scale = meta >> 8;
                    int decimalLength = MySQLUtils.getDecimalBinarySize(precision, scale);
                    columns.add(DecimalColumn.valueOf(MySQLUtils.toDecimal(precision, scale, is.readBytes(decimalLength)), precision, scale));
                    continue block30;
                }
                case 254: {
                    int stringLength = length < 256 ? is.readInt(1) : is.readInt(2);
                    columns.add(is.readFixedLengthString(stringLength));
                    continue block30;
                }
                case 15: 
                case 253: {
                    int varcharLength = meta < 256 ? is.readInt(1) : is.readInt(2);
                    columns.add(is.readFixedLengthString(varcharLength));
                    continue block30;
                }
                case 19: {
                    int value1 = is.readInt(3, false);
                    int nanos1 = is.readInt((meta + 1) / 2, false);
                    columns.add(Time2Column.valueOf(MySQLUtils.toTime2(value1, nanos1)));
                    continue block30;
                }
                case 18: {
                    long value2 = is.readLong(5, false);
                    int nanos2 = is.readInt((meta + 1) / 2, false);
                    columns.add(Datetime2Column.valueOf(MySQLUtils.toDatetime2(value2, nanos2)));
                    continue block30;
                }
                case 17: {
                    long value3 = is.readLong(4, false);
                    int nanos3 = is.readInt((meta + 1) / 2, false);
                    columns.add(Timestamp2Column.valueOf(MySQLUtils.toTimestamp2(value3, nanos3)));
                    continue block30;
                }
                default: {
                    throw new RuntimeException("assertion failed, unknown column type: " + type);
                }
            }
        }
        return new Row(columns);
    }
}

