/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.variable.status;

import com.google.code.or.binlog.impl.variable.status.AbstractStatusVariable;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.common.util.ToStringBuilder;
import com.google.code.or.io.XInputStream;
import java.io.IOException;

public class QUpdatedDBNames
extends AbstractStatusVariable {
    public static final int TYPE = 12;
    private final int accessedDbCount;
    private final StringColumn[] accessedDbs;

    public QUpdatedDBNames(int accessedDbCount, StringColumn[] accessedDbs) {
        super(12);
        this.accessedDbCount = accessedDbCount;
        this.accessedDbs = accessedDbs;
    }

    public String toString() {
        return new ToStringBuilder(this).append("accessedDbCount", this.accessedDbCount).append("accessedDbs", this.accessedDbs).toString();
    }

    public int getAccessedDbCount() {
        return this.accessedDbCount;
    }

    public StringColumn[] getAccessedDbs() {
        return this.accessedDbs;
    }

    public static QUpdatedDBNames valueOf(XInputStream tis) throws IOException {
        int accessedDbCount = tis.readInt(1);
        StringColumn[] accessedDbs = null;
        if (accessedDbCount > 16) {
            accessedDbCount = 254;
        } else {
            accessedDbs = new StringColumn[accessedDbCount];
            for (int i = 0; i < accessedDbCount; ++i) {
                accessedDbs[i] = tis.readNullTerminatedString();
            }
        }
        return new QUpdatedDBNames(accessedDbCount, accessedDbs);
    }
}

