/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary;

import com.google.code.or.common.util.CodecUtils;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    private static final long serialVersionUID = -2263391850849681361L;
    private static final UnsignedLong[] CACHE = new UnsignedLong[255];

    public boolean equals(Object obj) {
        if (!(obj instanceof UnsignedLong)) {
            return false;
        }
        return this.doubleValue() == ((UnsignedLong)obj).doubleValue();
    }

    @Override
    public int compareTo(UnsignedLong rhs) {
        return this.doubleValue() < rhs.doubleValue() ? -1 : (this.doubleValue() == rhs.doubleValue() ? 0 : 1);
    }

    public static final UnsignedLong valueOf(long value) {
        if (value < 0L) {
            return new UnsignedLongUnlimited(value);
        }
        if (value < (long)CACHE.length) {
            return CACHE[(int)value];
        }
        if (value < Integer.MAX_VALUE) {
            return new UnsignedLong4((int)value);
        }
        return new UnsignedLong8(value);
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            UnsignedLong.CACHE[i] = new UnsignedLong4(i);
        }
    }

    private static final class UnsignedLongUnlimited
    extends UnsignedLong {
        private static final long serialVersionUID = -5362638763306527191L;
        private final BigInteger value;

        private UnsignedLongUnlimited(long value) {
            this.value = new BigInteger(1, CodecUtils.toByteArray(value));
        }

        public int intValue() {
            return this.value.intValue();
        }

        public long longValue() {
            return this.value.longValue();
        }

        public float floatValue() {
            return this.value.floatValue();
        }

        public double doubleValue() {
            return this.value.doubleValue();
        }

        public String toString() {
            return this.value.toString();
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class UnsignedLong8
    extends UnsignedLong {
        private static final long serialVersionUID = -314206857441911721L;
        private final long value;

        private UnsignedLong8(long value) {
            this.value = value;
        }

        public int intValue() {
            return (int)this.value;
        }

        public long longValue() {
            return this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    private static final class UnsignedLong4
    extends UnsignedLong {
        private static final long serialVersionUID = 6549354506227481646L;
        private final int value;

        private UnsignedLong4(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public int hashCode() {
            return this.value;
        }
    }
}

