/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class NullColumn
implements Column {
    private static final long serialVersionUID = 3300119160243172731L;
    private static final NullColumn[] CACHE = new NullColumn[256];
    private final int type;

    private NullColumn(int type) {
        this.type = type;
    }

    public String toString() {
        return "null";
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return null;
    }

    public static final NullColumn valueOf(int type) {
        if (type < 0 || type >= CACHE.length) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
        return CACHE[type];
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            NullColumn.CACHE[i] = new NullColumn(i);
        }
    }
}

