/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class ShortColumn
implements Column {
    private static final long serialVersionUID = 2278283065371267842L;
    public static final int MIN_VALUE = Short.MIN_VALUE;
    public static final int MAX_VALUE = Short.MAX_VALUE;
    private static final ShortColumn[] CACHE = new ShortColumn[255];
    private final int value;

    private ShortColumn(int value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public static final ShortColumn valueOf(int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("invalid value: " + value);
        }
        int index = value - -128;
        return index >= 0 && index < CACHE.length ? CACHE[index] : new ShortColumn(value);
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            ShortColumn.CACHE[i] = new ShortColumn(i + -128);
        }
    }
}

