/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.io.impl;

import com.google.code.or.common.glossary.UnsignedLong;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.io.XOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XOutputStreamImpl
extends BufferedOutputStream
implements XOutputStream {
    public XOutputStreamImpl(OutputStream out) {
        super(out);
    }

    public final void writeBytes(byte[] value) throws IOException {
        super.write(value, 0, value.length);
    }

    public final void writeBytes(int value, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            super.write(value);
        }
    }

    public final void writeBytes(byte[] value, int offset, int length) throws IOException {
        super.write(value, offset, length);
    }

    public final void writeInt(int value, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            super.write(0xFF & value >>> (i << 3));
        }
    }

    public final void writeLong(long value, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            super.write((int)(0xFFL & value >>> (i << 3)));
        }
    }

    public final void writeUnsignedLong(UnsignedLong value) throws IOException {
        long length = value.longValue();
        if (length < 0L) {
            this.writeLong(254L, 1);
            this.writeLong(length, 8);
        } else if (length < 251L) {
            this.writeLong(length, 1);
        } else if (length < 65536L) {
            this.writeLong(252L, 1);
            this.writeLong(length, 2);
        } else if (length < 0x1000000L) {
            this.writeLong(253L, 1);
            this.writeLong(length, 3);
        } else {
            this.writeLong(254L, 1);
            this.writeLong(length, 8);
        }
    }

    public final void writeLengthCodedString(StringColumn value) throws IOException {
        this.writeUnsignedLong(UnsignedLong.valueOf(value.getValue().length));
        this.writeFixedLengthString(value);
    }

    public final void writeFixedLengthString(StringColumn value) throws IOException {
        super.write(value.getValue());
    }

    public final void writeNullTerminatedString(StringColumn value) throws IOException {
        super.write(value.getValue());
        super.write(0);
    }
}

