/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl;

import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.common.util.MySQLUtils;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.Transport;
import com.google.code.or.net.TransportContext;
import com.google.code.or.net.TransportException;
import com.google.code.or.net.impl.packet.ErrorPacket;
import com.google.code.or.net.impl.packet.OKPacket;
import com.google.code.or.net.impl.packet.RawPacket;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorImpl
implements Transport.Authenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatorImpl.class);
    public static final int DEFAULT_CAPABILITIES = 33284;
    protected String user;
    protected String password;
    protected String initialSchema;
    protected int clientCollation;
    protected int clientCapabilities;
    protected int maximumPacketLength;
    protected String encoding = "utf-8";

    public void login(Transport transport) throws IOException {
        TransportContext ctx = transport.getContext();
        LOGGER.info("start to login, user: {}, host: {}, port: {}", new Object[]{this.user, ctx.getServerHost(), ctx.getServerPort()});
        XSerializer s = new XSerializer(64);
        s.writeInt(this.buildClientCapabilities(), 4);
        s.writeInt(this.maximumPacketLength, 4);
        s.writeInt(this.clientCollation > 0 ? this.clientCollation : ctx.getServerCollation(), 1);
        s.writeBytes(0, 23);
        s.writeNullTerminatedString(StringColumn.valueOf(this.user.getBytes(this.encoding)));
        s.writeInt(20, 1);
        s.writeBytes(MySQLUtils.password41OrLater(this.password.getBytes(this.encoding), ctx.getScramble().getBytes(this.encoding)));
        if (this.initialSchema != null) {
            s.writeNullTerminatedString(StringColumn.valueOf(this.initialSchema.getBytes(this.encoding)));
        }
        RawPacket request = new RawPacket();
        request.setSequence(1);
        request.setPacketBody(s.toByteArray());
        request.setLength(request.getPacketBody().length);
        transport.getOutputStream().writePacket(request);
        transport.getOutputStream().flush();
        Packet response = transport.getInputStream().readPacket();
        if (response.getPacketBody()[0] == -1) {
            ErrorPacket error = ErrorPacket.valueOf(response);
            LOGGER.info("login failed, user: {}, error: {}", (Object)this.user, (Object)error);
            throw new TransportException(error);
        }
        if (response.getPacketBody()[0] == -2) {
            LOGGER.info("Old style password authentication is not supported, upgrade user {} to a new style password or specify a different user", (Object)this.user);
            throw new RuntimeException("Old style password authentication not supported");
        }
        if (response.getPacketBody()[0] != 0) {
            LOGGER.warn("login failed, unknown packet: ", (Object)response);
            throw new RuntimeException("assertion failed, invalid packet: " + response);
        }
        OKPacket ok = OKPacket.valueOf(response);
        LOGGER.info("login successfully, user: {}, detail: {}", (Object)this.user, (Object)ok);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getInitialSchema() {
        return this.initialSchema;
    }

    public void setInitialSchema(String schema) {
        this.initialSchema = schema;
    }

    public int getClientCollation() {
        return this.clientCollation;
    }

    public void setClientCollation(int collation) {
        this.clientCollation = collation;
    }

    public int getClientCapabilities() {
        return this.clientCapabilities;
    }

    public void setClientCapabilities(int capabilities) {
        this.clientCapabilities = capabilities;
    }

    public int getMaximumPacketLength() {
        return this.maximumPacketLength;
    }

    public void setMaximumPacketLength(int packetLength) {
        this.maximumPacketLength = packetLength;
    }

    protected int buildClientCapabilities() {
        int r;
        int n = r = this.clientCapabilities > 0 ? this.clientCapabilities : 33284;
        if (this.initialSchema != null) {
            r |= 8;
        }
        return r;
    }
}

