/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl;

import com.google.code.or.io.impl.XInputStreamImpl;
import com.google.code.or.net.Packet;
import com.google.code.or.net.TransportInputStream;
import com.google.code.or.net.impl.packet.RawPacket;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportInputStreamImpl
extends XInputStreamImpl
implements TransportInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportInputStreamImpl.class);
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private int currentPacketSequence;

    public TransportInputStreamImpl(InputStream is) {
        super(is);
        this.readCount = 0;
        this.readLimit = 0;
    }

    public TransportInputStreamImpl(InputStream is, int size) {
        super(is, size);
        this.readCount = 0;
        this.readLimit = 0;
    }

    public Packet readPacket() throws IOException {
        RawPacket r = this.readPacketHeader();
        byte[] body = new byte[r.getLength()];
        this.read(body, 0, r.getLength());
        r.setPacketBody(body);
        return r;
    }

    private RawPacket readPacketHeader() throws IOException {
        RawPacket r = new RawPacket();
        this.setReadLimit(4);
        int packetLength = this.readInt(3);
        this.currentPacketSequence = this.readInt(1);
        this.setReadLimit(packetLength);
        r.setLength(packetLength);
        r.setSequence(this.currentPacketSequence);
        return r;
    }

    public int read() throws IOException {
        if (this.readCount + 1 > this.readLimit) {
            this.readPacketHeader();
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int left = len;
        while (this.readCount + left > this.readLimit) {
            int remaining_length = this.readLimit - this.readCount;
            super.read(b, off, remaining_length);
            this.readPacketHeader();
            left -= remaining_length;
            off += remaining_length;
        }
        super.read(b, off, left);
        return len;
    }

    public int currentPacketLength() {
        return this.readLimit;
    }

    public int currentPacketSequence() {
        return this.currentPacketSequence;
    }
}

