/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.parser;

import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.binlog.BinlogParserContext;
import com.google.code.or.binlog.impl.event.FormatDescriptionEvent;
import com.google.code.or.binlog.impl.parser.AbstractBinlogEventParser;
import com.google.code.or.io.XInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatDescriptionEventParser
extends AbstractBinlogEventParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatDescriptionEventParser.class);

    public FormatDescriptionEventParser() {
        super(15);
    }

    public void parse(XInputStream is, BinlogEventV4Header header, BinlogParserContext context) throws IOException {
        FormatDescriptionEvent event = new FormatDescriptionEvent(header);
        event.setBinlogFilename(context.getBinlogFileName());
        event.setBinlogVersion(is.readInt(2));
        event.setServerVersion(is.readFixedLengthString(50));
        event.setCreateTimestamp(is.readLong(4) * 1000L);
        event.setHeaderLength(is.readInt(1));
        int eventTypeLength = (int)(event.getHeader().getEventLength() - (long)(event.getHeaderLength() + 57));
        byte[] eventTypeBuffer = event.checksumPossible() ? is.readBytes(eventTypeLength - 4) : is.readBytes(eventTypeLength);
        event.setEventTypes(eventTypeBuffer);
        if (event.checksumPossible()) {
            is.readBytes(4);
        }
        context.setChecksumEnabled(event.checksumEnabled());
        context.getEventListener().onEvents(event);
    }
}

