/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class Int24Column
implements Column {
    private static final long serialVersionUID = 6456161237369680803L;
    public static final int MIN_VALUE = -8388608;
    public static final int MAX_VALUE = 0x7FFFFF;
    private static final Int24Column[] CACHE = new Int24Column[255];
    private final int value;

    private Int24Column(int value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public static final Int24Column valueOf(int value) {
        if (value < -8388608 || value > 0x7FFFFF) {
            throw new IllegalArgumentException("invalid value: " + value);
        }
        int index = value - -128;
        return index >= 0 && index < CACHE.length ? CACHE[index] : new Int24Column(value);
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            Int24Column.CACHE[i] = new Int24Column(i + -128);
        }
    }
}

