/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.util;

import com.google.code.or.common.util.CodecUtils;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public final class MySQLUtils {
    private static final int DIGITS_PER_4BYTES = 9;
    private static final BigDecimal POSITIVE_ONE = BigDecimal.ONE;
    private static final BigDecimal NEGATIVE_ONE = new BigDecimal("-1");
    private static final int[] DECIMAL_BINARY_SIZE = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};

    public static byte[] password41OrLater(byte[] password, byte[] scramble) {
        byte[] stage1 = CodecUtils.sha(password);
        byte[] stage2 = CodecUtils.sha(CodecUtils.concat(scramble, CodecUtils.sha(stage1)));
        return CodecUtils.xor(stage1, stage2);
    }

    public static int toYear(int value) {
        return 1900 + value;
    }

    public static java.sql.Date toDate(int value) {
        int d = value % 32;
        int m = (value >>>= 5) % 16;
        int y = value >> 4;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(y, m - 1, d);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Time toTime(int value) {
        int s = value % 100;
        int m = (value /= 100) % 100;
        int h = value / 100;
        Calendar c = Calendar.getInstance();
        c.set(1970, 0, 1, h, m, s);
        c.set(14, 0);
        return new Time(c.getTimeInMillis());
    }

    public static Time toTime2(int value, int fraction, int width) {
        int h = value >> 12 & 0x3FF;
        int m = value >> 6 & 0x3F;
        int s = value >> 0 & 0x3F;
        Calendar c = Calendar.getInstance();
        c.set(1970, 0, 1, h, m, s);
        c.set(14, 0);
        long millis = c.getTimeInMillis();
        return new Time(millis + (long)(MySQLUtils.nanosForFractionalValue(fraction, width) / 1000000));
    }

    public static int nanosForFractionalValue(int value, int width) {
        switch (width) {
            case 0: {
                return 0;
            }
            case 1: {
                return value * 10000000;
            }
            case 2: {
                return value * 100000;
            }
            case 3: {
                return value * 1000;
            }
        }
        throw new RuntimeException("unexpected number of fractional bytes");
    }

    public static Date toDatetime(long value) {
        int second = (int)(value % 100L);
        int minute = (int)((value /= 100L) % 100L);
        int hour = (int)((value /= 100L) % 100L);
        int day = (int)((value /= 100L) % 100L);
        int month = (int)((value /= 100L) % 100L);
        int year = (int)(value / 100L);
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date toDatetime2(long value, int fraction, int width) {
        long x = value >> 22 & 0x1FFFFL;
        int year = (int)(x / 13L);
        int month = (int)(x % 13L);
        int day = (int)(value >> 17) & 0x1F;
        int hour = (int)(value >> 12) & 0x1F;
        int minute = (int)(value >> 6) & 0x3F;
        int second = (int)(value >> 0) & 0x3F;
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, 0);
        long millis = c.getTimeInMillis();
        return new Date(millis + (long)(MySQLUtils.nanosForFractionalValue(fraction, width) / 1000000));
    }

    public static Timestamp toTimestamp(long seconds) {
        return new Timestamp(seconds * 1000L);
    }

    public static Timestamp toTimestamp2(long seconds, int fraction, int width) {
        Timestamp r = new Timestamp(seconds * 1000L);
        r.setNanos(MySQLUtils.nanosForFractionalValue(fraction, width));
        return r;
    }

    public static BigDecimal toDecimal(int precision, int scale, byte[] value) {
        int i;
        BigDecimal ip;
        boolean positive = (value[0] & 0x80) == 128;
        value[0] = (byte)(value[0] ^ 0x80);
        if (!positive) {
            int i2 = 0;
            while (i2 < value.length) {
                int n = i2++;
                value[n] = (byte)(value[n] ^ 0xFF);
            }
        }
        int x = precision - scale;
        int ipDigits = x / 9;
        int ipDigitsX = x - ipDigits * 9;
        int ipSize = (ipDigits << 2) + DECIMAL_BINARY_SIZE[ipDigitsX];
        int offset = DECIMAL_BINARY_SIZE[ipDigitsX];
        BigDecimal bigDecimal = ip = offset > 0 ? BigDecimal.valueOf(CodecUtils.toInt(value, 0, offset)) : BigDecimal.ZERO;
        while (offset < ipSize) {
            int i3 = CodecUtils.toInt(value, offset, 4);
            ip = ip.movePointRight(9).add(BigDecimal.valueOf(i3));
            offset += 4;
        }
        int shift = 0;
        BigDecimal fp = BigDecimal.ZERO;
        while (shift + 9 <= scale) {
            i = CodecUtils.toInt(value, offset, 4);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(shift + 9));
            shift += 9;
            offset += 4;
        }
        if (shift < scale) {
            i = CodecUtils.toInt(value, offset, DECIMAL_BINARY_SIZE[scale - shift]);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(scale));
        }
        return positive ? POSITIVE_ONE.multiply(ip.add(fp)) : NEGATIVE_ONE.multiply(ip.add(fp));
    }

    public static int getDecimalBinarySize(int precision, int scale) {
        int x = precision - scale;
        int ipDigits = x / 9;
        int fpDigits = scale / 9;
        int ipDigitsX = x - ipDigits * 9;
        int fpDigitsX = scale - fpDigits * 9;
        return (ipDigits << 2) + DECIMAL_BINARY_SIZE[ipDigitsX] + (fpDigits << 2) + DECIMAL_BINARY_SIZE[fpDigitsX];
    }
}

