/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.io.impl;

import com.google.code.or.common.glossary.UnsignedLong;
import com.google.code.or.common.glossary.column.BitColumn;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.common.util.CodecUtils;
import com.google.code.or.io.ExceedLimitException;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.util.XSerializer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class XInputStreamImpl
extends InputStream
implements XInputStream {
    private int head = 0;
    private int tail = 0;
    private final byte[] buffer;
    private final InputStream is;
    protected int readCount = 0;
    protected int readLimit = 0;

    public XInputStreamImpl(InputStream is) {
        this(is, 524288);
    }

    public XInputStreamImpl(InputStream is, int size) {
        this.is = is;
        this.buffer = new byte[size];
    }

    public int readInt(int length) throws IOException {
        return this.readInt(length, true);
    }

    public long readLong(int length) throws IOException {
        return this.readLong(length, true);
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] r = new byte[length];
        this.read(r, 0, length);
        return r;
    }

    public BitColumn readBit(int length) throws IOException {
        return this.readBit(length, true);
    }

    public UnsignedLong readUnsignedLong() throws IOException {
        int v = this.read();
        if (v < 251) {
            return UnsignedLong.valueOf(v);
        }
        if (v == 251) {
            return null;
        }
        if (v == 252) {
            return UnsignedLong.valueOf(this.readInt(2));
        }
        if (v == 253) {
            return UnsignedLong.valueOf(this.readInt(3));
        }
        if (v == 254) {
            return UnsignedLong.valueOf(this.readLong(8));
        }
        throw new RuntimeException("assertion failed, should NOT reach here");
    }

    public StringColumn readLengthCodedString() throws IOException {
        UnsignedLong length = this.readUnsignedLong();
        return length == null ? null : this.readFixedLengthString(length.intValue());
    }

    public StringColumn readNullTerminatedString() throws IOException {
        int v;
        XSerializer s = new XSerializer(128);
        while ((v = this.read()) != 0) {
            s.writeInt(v, 1);
        }
        return StringColumn.valueOf(s.toByteArray());
    }

    public StringColumn readFixedLengthString(int length) throws IOException {
        return StringColumn.valueOf(this.readBytes(length));
    }

    public int readSignedInt(int length) throws IOException {
        int r = 0;
        for (int i = 0; i < length; ++i) {
            int v = this.read();
            r |= v << (i << 3);
            if (i != length - 1 || (v & 0x80) != 128) continue;
            for (int j = length; j < 4; ++j) {
                r |= 255 << (j << 3);
            }
        }
        return r;
    }

    public long readSignedLong(int length) throws IOException {
        long r = 0L;
        for (int i = 0; i < length; ++i) {
            long v = this.read();
            r |= v << (i << 3);
            if (i != length - 1 || (v & 0x80L) != 128L) continue;
            for (int j = length; j < 8; ++j) {
                r |= (long)(255 << (j << 3));
            }
        }
        return r;
    }

    public int readInt(int length, boolean littleEndian) throws IOException {
        int r = 0;
        for (int i = 0; i < length; ++i) {
            int v = this.read();
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        return r;
    }

    public long readLong(int length, boolean littleEndian) throws IOException {
        long r = 0L;
        for (int i = 0; i < length; ++i) {
            long v = this.read();
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        return r;
    }

    public BitColumn readBit(int length, boolean littleEndian) throws IOException {
        byte[] bytes = this.readBytes(length + 7 >> 3);
        if (!littleEndian) {
            bytes = CodecUtils.toBigEndian(bytes);
        }
        return BitColumn.valueOf(length, bytes);
    }

    public void close() throws IOException {
        this.is.close();
    }

    public void setReadLimit(int limit) throws IOException {
        this.readCount = 0;
        this.readLimit = limit;
    }

    public int available() throws IOException {
        if (this.readLimit > 0) {
            return this.readLimit - this.readCount;
        }
        return this.tail - this.head + this.is.available();
    }

    public boolean hasMore() throws IOException {
        if (this.head < this.tail) {
            return true;
        }
        return this.available() > 0;
    }

    public long skip(long n) throws IOException {
        if (this.readLimit > 0 && (long)this.readCount + n > (long)this.readLimit) {
            this.readCount = (int)((long)this.readCount + this.doSkip(this.readLimit - this.readCount));
            throw new ExceedLimitException();
        }
        this.readCount = (int)((long)this.readCount + this.doSkip(n));
        return n;
    }

    public int read() throws IOException {
        if (this.readLimit > 0 && this.readCount + 1 > this.readLimit) {
            throw new ExceedLimitException();
        }
        if (this.head >= this.tail) {
            this.doFill();
        }
        int r = this.buffer[this.head++] & 0xFF;
        ++this.readCount;
        return r;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readLimit > 0 && this.readCount + len > this.readLimit) {
            this.readCount += this.doRead(b, off, this.readLimit - this.readCount);
            throw new ExceedLimitException();
        }
        this.readCount += this.doRead(b, off, len);
        return len;
    }

    private void doFill() throws IOException {
        this.head = 0;
        this.tail = this.is.read(this.buffer, 0, this.buffer.length);
        if (this.tail <= 0) {
            throw new EOFException();
        }
    }

    private long doSkip(long n) throws IOException {
        int availabale;
        for (long total = n; total > 0L; total -= (long)availabale) {
            availabale = this.tail - this.head;
            if ((long)availabale >= total) {
                this.head = (int)((long)this.head + total);
                break;
            }
            this.doFill();
        }
        return n;
    }

    private int doRead(byte[] b, int off, int len) throws IOException {
        int available;
        int index = off;
        for (int total = len; total > 0; total -= available) {
            available = this.tail - this.head;
            if (available >= total) {
                System.arraycopy(this.buffer, this.head, b, index, total);
                this.head += total;
                break;
            }
            System.arraycopy(this.buffer, this.head, b, index, available);
            index += available;
            this.doFill();
        }
        return len;
    }
}

