/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl;

import com.google.code.or.common.util.IOUtils;
import com.google.code.or.io.SocketFactory;
import com.google.code.or.io.util.ActiveBufferedInputStream;
import com.google.code.or.net.Packet;
import com.google.code.or.net.TransportException;
import com.google.code.or.net.TransportInputStream;
import com.google.code.or.net.TransportOutputStream;
import com.google.code.or.net.impl.AbstractTransport;
import com.google.code.or.net.impl.TransportInputStreamImpl;
import com.google.code.or.net.impl.TransportOutputStreamImpl;
import com.google.code.or.net.impl.packet.ErrorPacket;
import com.google.code.or.net.impl.packet.GreetingPacket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportImpl
extends AbstractTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportImpl.class);
    protected Socket socket;
    protected TransportInputStream is;
    protected TransportOutputStream os;
    protected SocketFactory socketFactory;
    protected int level1BufferSize = 0x100000;
    protected int level2BufferSize = 0x800000;
    protected final AtomicBoolean connected = new AtomicBoolean(false);

    public boolean isConnected() {
        return this.connected.get();
    }

    public void connect(String host, int port) throws Exception {
        if (!this.connected.compareAndSet(false, true)) {
            return;
        }
        if (this.isVerbose() && LOGGER.isInfoEnabled()) {
            LOGGER.debug("connecting to host: {}, port: {}", (Object)host, (Object)port);
        }
        this.socket = this.socketFactory.create(host, port);
        this.os = new TransportOutputStreamImpl(this.socket.getOutputStream());
        this.is = this.level2BufferSize <= 0 ? new TransportInputStreamImpl(this.socket.getInputStream(), this.level1BufferSize) : new TransportInputStreamImpl(new ActiveBufferedInputStream(this.socket.getInputStream(), this.level2BufferSize), this.level1BufferSize);
        Packet packet = this.is.readPacket();
        if (packet.getPacketBody()[0] == -1) {
            ErrorPacket error = ErrorPacket.valueOf(packet);
            LOGGER.warn("failed to connect to host: {}, port: {}, error", new Object[]{host, port, error});
            throw new TransportException(error);
        }
        GreetingPacket greeting = GreetingPacket.valueOf(packet);
        this.context.setServerHost(host);
        this.context.setServerPort(port);
        this.context.setServerStatus(greeting.getServerStatus());
        this.context.setServerVersion(greeting.getServerVersion().toString());
        this.context.setServerCollation(greeting.getServerCollation());
        this.context.setServerCapabilities(greeting.getServerCapabilities());
        this.context.setThreadId(greeting.getThreadId());
        this.context.setProtocolVersion(greeting.getProtocolVersion());
        this.context.setScramble(greeting.getScramble1().toString() + greeting.getScramble2().toString());
        if (this.isVerbose() && LOGGER.isInfoEnabled()) {
            LOGGER.debug("connected to host: {}, port: {}, context: {}", new Object[]{host, port, this.context});
        }
        this.authenticator.login(this);
    }

    public void disconnect() throws Exception {
        if (!this.connected.compareAndSet(true, false)) {
            return;
        }
        IOUtils.closeQuietly(this.is);
        IOUtils.closeQuietly(this.os);
        IOUtils.closeQuietly(this.socket);
        if (this.isVerbose() && LOGGER.isInfoEnabled()) {
            LOGGER.debug("disconnected from {}:{}", (Object)this.context.getServerHost(), (Object)this.context.getServerPort());
        }
    }

    public int getLevel1BufferSize() {
        return this.level1BufferSize;
    }

    public void setLevel1BufferSize(int size) {
        this.level1BufferSize = size;
    }

    public int getLevel2BufferSize() {
        return this.level2BufferSize;
    }

    public void setLevel2BufferSize(int size) {
        this.level2BufferSize = size;
    }

    public TransportInputStream getInputStream() {
        return this.is;
    }

    public TransportOutputStream getOutputStream() {
        return this.os;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }
}

