/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.glossary.UnsignedLong;
import com.google.code.or.common.util.ToStringBuilder;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;

public class ResultSetHeaderPacket
extends AbstractPacket {
    private static final long serialVersionUID = -5491186291875548645L;
    private UnsignedLong fieldCount;
    private UnsignedLong extra;

    public String toString() {
        return new ToStringBuilder(this).append("fieldCount", this.fieldCount).append("extra", this.extra).toString();
    }

    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(32);
        s.writeUnsignedLong(this.fieldCount);
        if (this.extra != null) {
            s.writeUnsignedLong(this.extra);
        }
        return s.toByteArray();
    }

    public UnsignedLong getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(UnsignedLong fieldCount) {
        this.fieldCount = fieldCount;
    }

    public UnsignedLong getExtra() {
        return this.extra;
    }

    public void setExtra(UnsignedLong extra) {
        this.extra = extra;
    }

    public static ResultSetHeaderPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        ResultSetHeaderPacket r = new ResultSetHeaderPacket();
        r.length = packet.getLength();
        r.sequence = packet.getSequence();
        r.fieldCount = d.readUnsignedLong();
        if (d.available() > 0) {
            r.extra = d.readUnsignedLong();
        }
        return r;
    }
}

