/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl;

import com.google.code.or.binlog.BinlogEventFilter;
import com.google.code.or.binlog.BinlogEventListener;
import com.google.code.or.binlog.BinlogEventParser;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.BinlogParser;
import com.google.code.or.binlog.BinlogParserContext;
import com.google.code.or.binlog.BinlogParserListener;
import com.google.code.or.binlog.impl.event.RotateEvent;
import com.google.code.or.binlog.impl.event.TableMapEvent;
import com.google.code.or.binlog.impl.parser.NopEventParser;
import com.google.code.or.common.util.XThreadFactory;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinlogParser
implements BinlogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBinlogParser.class);
    protected Thread worker;
    protected ThreadFactory threadFactory;
    protected BinlogEventFilter eventFilter;
    protected BinlogEventListener eventListener;
    protected boolean clearTableMapEventsOnRotate = true;
    protected final List<BinlogParserListener> parserListeners;
    protected final AtomicBoolean verbose = new AtomicBoolean(false);
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final BinlogEventParser defaultParser = new NopEventParser();
    protected final BinlogEventParser[] parsers = new BinlogEventParser[128];
    protected String binlogFileName;

    protected abstract void doParse() throws Exception;

    protected abstract void doStart() throws Exception;

    protected abstract void doStop(long var1, TimeUnit var3) throws Exception;

    public AbstractBinlogParser() {
        this.threadFactory = new XThreadFactory("binlog-parser", false);
        this.parserListeners = new CopyOnWriteArrayList<BinlogParserListener>();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.doStart();
        this.worker = this.threadFactory.newThread(new Task());
        this.worker.start();
        this.notifyOnStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long timeout, TimeUnit unit) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        try {
            long now = System.nanoTime();
            this.doStop(timeout, unit);
            if ((timeout -= unit.convert(System.nanoTime() - now, TimeUnit.NANOSECONDS)) > 0L) {
                unit.timedJoin(this.worker, timeout);
                this.worker = null;
            }
        }
        finally {
            this.notifyOnStop();
        }
    }

    public boolean isVerbose() {
        return this.verbose.get();
    }

    public void setVerbose(boolean verbose) {
        this.verbose.set(verbose);
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory tf) {
        this.threadFactory = tf;
    }

    public BinlogEventFilter getEventFilter() {
        return this.eventFilter;
    }

    @Override
    public void setEventFilter(BinlogEventFilter filter) {
        this.eventFilter = filter;
    }

    public BinlogEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setEventListener(BinlogEventListener listener) {
        this.eventListener = listener;
    }

    public boolean isClearTableMapEventsOnRotate() {
        return this.clearTableMapEventsOnRotate;
    }

    public void setClearTableMapEventsOnRotate(boolean clearTableMapEventsOnRotate) {
        this.clearTableMapEventsOnRotate = clearTableMapEventsOnRotate;
    }

    public void clearEventParsers() {
        for (int i = 0; i < this.parsers.length; ++i) {
            this.parsers[i] = null;
        }
    }

    public BinlogEventParser getEventParser(int type) {
        return this.parsers[type];
    }

    public BinlogEventParser unregisterEventParser(int type) {
        this.parsers[type] = null;
        return null;
    }

    public void registerEventParser(BinlogEventParser parser) {
        this.parsers[parser.getEventType()] = parser;
    }

    @Deprecated
    public void registgerEventParser(BinlogEventParser parser) {
        this.registerEventParser(parser);
    }

    @Deprecated
    public BinlogEventParser unregistgerEventParser(int type) {
        return this.unregisterEventParser(type);
    }

    public void setEventParsers(List<BinlogEventParser> parsers) {
        this.clearEventParsers();
        if (parsers != null) {
            for (BinlogEventParser parser : parsers) {
                this.registerEventParser(parser);
            }
        }
    }

    @Override
    public List<BinlogParserListener> getParserListeners() {
        return new ArrayList<BinlogParserListener>(this.parserListeners);
    }

    @Override
    public boolean addParserListener(BinlogParserListener listener) {
        return this.parserListeners.add(listener);
    }

    @Override
    public boolean removeParserListener(BinlogParserListener listener) {
        return this.parserListeners.remove(listener);
    }

    @Override
    public void setParserListeners(List<BinlogParserListener> listeners) {
        this.parserListeners.clear();
        if (listeners != null) {
            this.parserListeners.addAll(listeners);
        }
    }

    public String getBinlogFileName() {
        return this.binlogFileName;
    }

    private void notifyOnStart() {
        for (BinlogParserListener listener : this.parserListeners) {
            listener.onStart(this);
        }
    }

    private void notifyOnStop() {
        for (BinlogParserListener listener : this.parserListeners) {
            listener.onStop(this);
        }
    }

    private void notifyOnException(Exception exception) {
        for (BinlogParserListener listener : this.parserListeners) {
            listener.onException(this, exception);
        }
    }

    protected class Context
    implements BinlogParserContext,
    BinlogEventListener {
        private String binlogFileName;
        private final Map<Long, TableMapEvent> tableMapEvents = new HashMap<Long, TableMapEvent>();
        private boolean checksumEnabled;

        public Context(AbstractBinlogParser parser) {
            this.binlogFileName = parser.getBinlogFileName();
        }

        public final String getBinlogFileName() {
            return this.binlogFileName;
        }

        public final void setBinlogFileName(String name) {
            this.binlogFileName = name;
        }

        public final BinlogEventListener getEventListener() {
            return this;
        }

        public final TableMapEvent getTableMapEvent(long tableId) {
            return this.tableMapEvents.get(tableId);
        }

        public void onEvents(BinlogEventV4 event) {
            if (event == null) {
                return;
            }
            if (event instanceof TableMapEvent) {
                TableMapEvent tme = (TableMapEvent)event;
                this.tableMapEvents.put(tme.getTableId(), tme);
            } else if (event instanceof RotateEvent) {
                RotateEvent re = (RotateEvent)event;
                this.binlogFileName = re.getBinlogFileName().toString();
                if (AbstractBinlogParser.this.isClearTableMapEventsOnRotate()) {
                    this.tableMapEvents.clear();
                }
            }
            try {
                AbstractBinlogParser.this.eventListener.onEvents(event);
            }
            catch (Exception e) {
                LOGGER.error("failed to notify binlog event listener, event: " + event, (Throwable)e);
            }
        }

        public boolean getChecksumEnabled() {
            return this.checksumEnabled;
        }

        public void setChecksumEnabled(boolean flag) {
            this.checksumEnabled = flag;
        }
    }

    protected class Task
    implements Runnable {
        protected Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AbstractBinlogParser.this.doParse();
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                AbstractBinlogParser.this.notifyOnException(e);
                LOGGER.error("failed to parse binlog", (Throwable)e);
            }
            finally {
                try {
                    AbstractBinlogParser.this.stop(0L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOGGER.error("failed to stop binlog parser", (Throwable)e);
                }
            }
        }
    }
}

