/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl;

import com.google.code.or.binlog.BinlogEventParser;
import com.google.code.or.binlog.impl.AbstractBinlogParser;
import com.google.code.or.binlog.impl.event.BinlogEventV4HeaderImpl;
import com.google.code.or.binlog.impl.parser.FormatDescriptionEventParser;
import com.google.code.or.net.Transport;
import com.google.code.or.net.TransportInputStream;
import com.google.code.or.net.impl.EventInputStream;
import com.google.code.or.net.impl.packet.EOFPacket;
import com.google.code.or.net.impl.packet.ErrorPacket;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationBasedBinlogParser
extends AbstractBinlogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationBasedBinlogParser.class);
    private final boolean stopOnEOF;
    protected long heartbeatCount = 0L;
    protected Long lastEventMillis = null;
    protected Transport transport;

    public ReplicationBasedBinlogParser(boolean stopOnEOF) {
        this.stopOnEOF = stopOnEOF;
    }

    public ReplicationBasedBinlogParser() {
        this(false);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop(long timeout, TimeUnit unit) throws Exception {
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getBinlogFileName() {
        return this.binlogFileName;
    }

    public void setBinlogFileName(String binlogFileName) {
        this.binlogFileName = binlogFileName;
    }

    private void readPacketMarker(TransportInputStream ts) throws IOException {
        int packetMarker = ts.readInt(1);
        if (packetMarker != 0) {
            if ((byte)packetMarker == -1) {
                ErrorPacket packet = ErrorPacket.valueOf(ts.currentPacketLength(), ts.currentPacketSequence(), packetMarker, ts);
                throw new RuntimeException(packet.toString());
            }
            if ((byte)packetMarker == -2) {
                if (this.stopOnEOF) {
                    throw new EOFException();
                }
                EOFPacket packet = EOFPacket.valueOf(ts.currentPacketLength(), ts.currentPacketSequence(), packetMarker, ts);
                throw new RuntimeException(packet.toString());
            }
            throw new RuntimeException("assertion failed, invalid packet marker: " + packetMarker);
        }
    }

    public long getHeartbeatCount() {
        return this.heartbeatCount;
    }

    public Long millisSinceLastEvent() {
        if (this.lastEventMillis == null) {
            return null;
        }
        return System.currentTimeMillis() - this.lastEventMillis;
    }

    protected void doParse() throws Exception {
        TransportInputStream is = this.transport.getInputStream();
        EventInputStream es = new EventInputStream(is);
        AbstractBinlogParser.Context context = new AbstractBinlogParser.Context(this);
        while (this.isRunning()) {
            boolean isFormatDescriptionEvent;
            this.readPacketMarker(is);
            BinlogEventV4HeaderImpl header = es.getNextBinlogHeader();
            boolean bl = isFormatDescriptionEvent = header.getEventType() == 15;
            if (header.getEventType() == 27) {
                ++this.heartbeatCount;
            }
            this.lastEventMillis = System.currentTimeMillis();
            if (this.eventFilter != null && !this.eventFilter.accepts(header, context)) {
                if (isFormatDescriptionEvent) {
                    new FormatDescriptionEventParser().parse(es, header, context);
                } else {
                    this.defaultParser.parse(es, header, context);
                }
            } else {
                BinlogEventParser parser = this.getEventParser(header.getEventType());
                if (parser == null) {
                    parser = this.defaultParser;
                }
                parser.parse(es, header, context);
            }
            if (isFormatDescriptionEvent) {
                es.setChecksumEnabled(context.getChecksumEnabled());
            }
            es.finishEvent(header);
        }
    }
}

