/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.event;

import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.binlog.impl.event.AbstractBinlogEventV4;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.common.util.ToStringBuilder;
import java.util.Arrays;

public final class FormatDescriptionEvent
extends AbstractBinlogEventV4 {
    public static final int EVENT_TYPE = 15;
    private int binlogVersion;
    private StringColumn serverVersion;
    private long createTimestamp;
    private int headerLength;
    private byte[] eventTypes;

    public FormatDescriptionEvent() {
    }

    public FormatDescriptionEvent(BinlogEventV4Header header) {
        this.header = header;
    }

    public String toString() {
        return new ToStringBuilder(this).append("header", this.header).append("binlogVersion", this.binlogVersion).append("serverVersion", this.serverVersion).append("createTimestamp", this.createTimestamp).append("headerLength", this.headerLength).append("eventTypes", Arrays.toString(this.eventTypes)).toString();
    }

    public int getBinlogVersion() {
        return this.binlogVersion;
    }

    public void setBinlogVersion(int binlogVersion) {
        this.binlogVersion = binlogVersion;
    }

    public StringColumn getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(StringColumn serverVersion) {
        this.serverVersion = serverVersion;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    public byte[] getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(byte[] eventTypes) {
        this.eventTypes = eventTypes;
    }

    public boolean checksumEnabled() {
        if (this.checksumPossible()) {
            return this.eventTypes[this.eventTypes.length - 1] == 1;
        }
        return false;
    }

    public boolean checksumPossible() {
        Integer[] version = this.splitServerVersion();
        return version[0] >= 5 && version[1] >= 6 && version[2] >= 1;
    }

    private Integer[] splitServerVersion() {
        String version = this.serverVersion.toString();
        String[] versionSplit = version.split("\\.");
        Integer[] ret = new Integer[versionSplit.length];
        for (int i = 0; i < versionSplit.length; ++i) {
            ret[i] = Integer.parseInt(versionSplit[i].replaceAll("[^0-9]", ""));
        }
        return ret;
    }
}

