/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.parser;

import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.binlog.BinlogParserContext;
import com.google.code.or.binlog.impl.event.TableMapEvent;
import com.google.code.or.binlog.impl.parser.AbstractBinlogEventParser;
import com.google.code.or.common.glossary.Metadata;
import com.google.code.or.io.XInputStream;
import java.io.IOException;

public class TableMapEventParser
extends AbstractBinlogEventParser {
    private boolean reusePreviousEvent = true;

    public TableMapEventParser() {
        super(19);
    }

    public boolean isReusePreviousEvent() {
        return this.reusePreviousEvent;
    }

    public void setReusePreviousEvent(boolean reusePreviousEvent) {
        this.reusePreviousEvent = reusePreviousEvent;
    }

    public void parse(XInputStream is, BinlogEventV4Header header, BinlogParserContext context) throws IOException {
        long tableId = is.readLong(6);
        if (this.reusePreviousEvent && context.getTableMapEvent(tableId) != null) {
            is.skip(is.available());
            TableMapEvent event = context.getTableMapEvent(tableId).copy();
            event.setHeader(header);
            event.setBinlogFilename(context.getBinlogFileName());
            context.getEventListener().onEvents(event);
            return;
        }
        TableMapEvent event = new TableMapEvent(header);
        event.setBinlogFilename(context.getBinlogFileName());
        event.setTableId(tableId);
        event.setReserved(is.readInt(2));
        event.setDatabaseNameLength(is.readInt(1));
        event.setDatabaseName(is.readNullTerminatedString());
        event.setTableNameLength(is.readInt(1));
        event.setTableName(is.readNullTerminatedString());
        event.setColumnCount(is.readUnsignedLong());
        event.setColumnTypes(is.readBytes(event.getColumnCount().intValue()));
        event.setColumnMetadataCount(is.readUnsignedLong());
        event.setColumnMetadata(Metadata.valueOf(event.getColumnTypes(), is.readBytes(event.getColumnMetadataCount().intValue())));
        event.setColumnNullabilities(is.readBit(event.getColumnCount().intValue()));
        context.getEventListener().onEvents(event);
    }
}

