/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary;

import com.google.code.or.common.util.CodecUtils;
import com.google.code.or.common.util.ToStringBuilder;
import com.google.code.or.io.util.XDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public final class Metadata
implements Serializable {
    private static final long serialVersionUID = 4634414541769527837L;
    private final byte[] type;
    private final int[] metadata;

    public Metadata(byte[] type, int[] metadata) {
        this.type = type;
        this.metadata = metadata;
    }

    public String toString() {
        return new ToStringBuilder(this).append("metadata", Arrays.toString(this.metadata)).toString();
    }

    public byte getType(int column) {
        return this.type[column];
    }

    public int getMetadata(int column) {
        return this.metadata[column];
    }

    public static final Metadata valueOf(byte[] type, byte[] data) throws IOException {
        int[] metadata = new int[type.length];
        XDeserializer d = new XDeserializer(data);
        block6: for (int i = 0; i < type.length; ++i) {
            int t = CodecUtils.toUnsigned(type[i]);
            switch (t) {
                case 4: 
                case 5: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 255: {
                    metadata[i] = d.readInt(1);
                    continue block6;
                }
                case 15: 
                case 16: 
                case 246: {
                    metadata[i] = d.readInt(2);
                    continue block6;
                }
                case 247: 
                case 248: 
                case 254: {
                    metadata[i] = CodecUtils.toInt(d.readBytes(2), 0, 2);
                    continue block6;
                }
                case 17: 
                case 18: 
                case 19: {
                    metadata[i] = d.readInt(1);
                    continue block6;
                }
                default: {
                    metadata[i] = 0;
                }
            }
        }
        return new Metadata(type, metadata);
    }
}

